//    
// sello, 12.6.97 

/*++
cleanbas.mu -- delete all phase I slack variables out of the basis of the optimal tableau T
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::clean_basis:= 	proc(TT)

/* Eingabe: optimales PhaseI-Tableau
  Ausgabe: bereinigtes Tableau, eventuell die leere Menge, falls das PhaseI-Tableau nicht Zielfunktionswert 0 hat
*/
				local T, piv;	// Pivotelement	

				begin

              T:=TT;
              
				  if T = {} then return(Transparent::empty()) end_if:

				  if T[8] = {} then error(" The given tableau stems not from a phase I!") end_if:

				  piv := Transparent::pivot1(T[1],T[2],T[3],T[9],T[2]+2):

				  if piv[1] = 0 
				    then piv := Transparent::pivot2(T[1],T[2],T[3],T[9]):
					 if piv[2] = 0 
				    	   then if T[1][2,2] <> 0 then return(Transparent::empty()) end_if:
						repeat
						  piv := Transparent::drive_out(T):
						  if piv[1] = 0 
						    then return(T)
						    else T := Transparent::optstep(T,piv)
						  end_if:
userinfo(10,Transparent::uinfo(T)):
						until 1=0 end_repeat:
				           elif piv[1] = 0 
					       then error(" Phase I tableau is unbounded!")
					       else error(" Phase I tableau isn't optimal yet!")
				         end_if
				    elif piv[2] = 0 
					then return(Transparent::empty())
					else error(" Phase I tableau is infeasible!")
				  end_if

				end_proc:

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
