//    
// sello, 12.6.97 

/*++
driveout.mu -- return next pivotelement to drive out an phaseI slack variable out of the basis
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::drive_out	:=	proc(T)

/* Eingabe: Tableau T
  Ausgabe: Pivotelement fuer naechsten Pivotschritt
*/

				local t,	// Laufvariable	
				      tbl, slackanz, i, j, m, n;

				begin
				  tbl := T[1]:
				  m := T[2]:
				  n := T[3]:
				  slackanz := T[7]:
				  for i from 3 to m+2 do
				    if contains({hold(slk)[t]$ t=slackanz+1..2*slackanz},tbl[i,1]) 
				      then break
				    end_if	
				  end_for:
				  if i > m+2 then return([0,0]) end_if:
				  for j from 3 to n+2 do
				    if not contains({hold(slk)[t]$ t=slackanz+1..2*slackanz},tbl[1,j]) and tbl[i,j] <> 0 
				      then return([i,j,tbl[i,j],FALSE])
				    end_if
				  end_for:

				  error(" Redundant row ascertained! ")
				    
				end_proc: 

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
