//    
// sello, 12.6.97 

/*++
userstep.mu -- perform userdefined simplex step
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::userstep	:= 	proc(T,x,y)

/* Eingabe: Tableau T, Basisvariable x, Nichtbasisvariable y
  Ausgabe: Anschlusstableau
*/

				local tbl,m,n,/*slackanz,internalorder,*/	// Tableaukomponenten	
				      i,j;				// Laufvariablen		

				begin
          if args(0)<1 or type(T)<>linopt::Transparent then error("linalg::Transparent expected as first argument."); end_if;
          if args(0)<3 or type(T)<>linopt::Transparent then error("two variables expected"); end_if;
				  tbl := T[1]:
//print(tbl):
				  m := T[2]:
				  n := T[3]:

				  for j from 3 to n+2 do
				    if tbl[1,j] = y then break end_if
				  end_for:

				  for i from 3 to m+2 do
				    if tbl[i,1] = x then break end_if
				  end_for:

				  if i > m+2 then error(" No correct pivot element specified ") end_if:

				  if x <> y 
				   then if j > n+2 or tbl[i,j] = 0 then error(" No correct pivot element specified ") end_if:
				   else return(T) 
				  end_if:

				  return(Transparent::optstep(T,[i,j,tbl[i,j],FALSE]))
				end_proc:			

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
