//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
euklpen.mu -- calculate for Tableau T the euklidean penalties for the variable
 	      associate
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):



linopt::eukl_penalty:=
proc(T,tieindex,pivotcolumn,bound,upperboundpivot)

/*  
 Liefert das erste Pivotelement zum Sohnproblem mit den kleineren
 assoziierten  Strafkosten (Vorauswahl nach objective penalty ist vorher
 getroffen!) und mit den besten euklidischen Eigenschaften.

 Eingabe: T           - Tableau,
          tieindex    - Liste der Indizes der Zeilen von T der in Frage
                        kommenden Branchingvariablen,
          pivotcolumn - Tabelle: zu jedem Index aus tieindex eine Liste der
                        in Frage kommenden Pivotspalten,
          bound       - Tabelle: zu jedem Index aus tieindex die neue
                        Schranke im Sohnproblem mit den kleineren
                        assoziierten objective penalties,
          upperboundpivot - Tabelle: zu jedem Index aus tieindex ein
                            boolscher Wert: TRUE iff Pivotschritt um
                            beidseitig beschraenkte Variable
 Ausgabe: erstes Pivotelement fuer das Sohnproblem mit den kleineren
          assoziierten objective penalties (durch den Zeilen index ist
          dann auch eine endgueltige Entscheidung ueber die Branchingvariable
          gefallen)
*/

  local
  k,l,i,j,				         // Laufvariablen
  tbl,m,n,interval,integer,slacks,	// Tableaukomponenten
  eukl,				// Array, bibt fuer jede Spalte des Tableaus die
                  // euklidische Laenge ^2  des zugehoerigen Vektors an		
  setj,				// Menge der in Frage kommenden Pivotspalten				
  akt,pen,			// euklidische Strafkosten einer moeglichen
                  // Branchingvariablen		
  firstpivot;		// erstes Pivotelement, Rueckgabewert dieser Prozedur			
  
  
begin
  tbl := T[1]:
  m := T[2]:
  n := T[3]:
  slacks := {hold(slk)[i]$ i=1..T[8]}:
  interval := T[9]:
  integer := T[12]:
  
  setj := {(pivotcolumn[tieindex[i]][j]$ j=1..nops(pivotcolumn[tieindex[i]]))$ i=1..nops(tieindex)}:
  
  eukl := array(1..n+2):
  
  for l in setj do
    eukl[l] := 0:
    
    for k from 3 to m+2 do
      if not contains(slacks,tbl[k,1])
        then eukl[l] := eukl[l] + tbl[k,l]^2
      end_if:
      
    end_for:
    if not contains(slacks,tbl[1,l])
      then eukl[l] := eukl[l]+1
    end_if
  end_for:
  
  pen := eukl[pivotcolumn[tieindex[1]][1]]*
         (bound[tieindex[1]]-tbl[tieindex[1],2])^2/tbl[tieindex[1],pivotcolumn[tieindex[1]][1]]^2:
  
  firstpivot := [tieindex[1],pivotcolumn[tieindex[1]][1],upperboundpivot[tieindex[1]][1]]:
  delete pivotcolumn[tieindex[1]][1]:
  
  for i in tieindex do
    for j from 1 to nops(pivotcolumn[i]) do
      akt := eukl[pivotcolumn[i][j]]*
             (bound[i]-tbl[i,2])^2/tbl[i,pivotcolumn[i][j]]^2:
      if akt > pen
        then pen := akt:
        firstpivot := [i,pivotcolumn[i][j],upperboundpivot[i][j]]
      end_if
    end_for
  end_for:
  
  return(firstpivot)
end_proc:

				
unalias(Tableau):
unalias(Heap):

