/*

linopt::feasible - Check whether the constraints are feasible

If there are values satisfying the constraints, 
the system is called feasible.
	


Calling sequence:

linopt::feasible(LinCon [, Options ])

Parameter:

LinCon       - a set or list of linear constraints. A linear constraint 
               can be an equation or a non-strict inequality.
Options      - (optional) parameters.
               See linopt::maximize for valid options.

Return Value:

TRUE or FALSE

Examples:

>> c := {3*x+4*y-3*z <= 23, 5*x-4*y-3*z <= 10, 7*x+4*y+11*z <= 30}:
>> linopt::feasible(c)

	TRUE

>> c := [4*x+3*y <= 6, 4*x+3*y >= 7]:
>> linopt::feasible(c)

        FALSE

*/

linopt::feasible := proc(list)
  local a, r;
begin
  case args(0)
    of 1 do 
       a := [list, 1]; break
    otherwise
       a := [list, 1], args(2)..args(args(0))
  end_case;

  // linopt::Tableau::feasible seems not to work for all cases, 
  // for example linopt::feasible({x<=2, x>=2}) yields FALSE. 
  // The result should be TRUE.
  // r: = bool(linopt::Tableau::feasible(linopt::Transparent(a)));
  // return( r );

  r := linopt::maximize(a);
  if r[1] = hold(EMPTY) then 
     FALSE 
  else 
     // r[1] = OPTIMAL or UNBOUNDED
     TRUE
  end_if
     
end_proc:
