//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
plotdata.mu -- generate the plot-statement for the feasible region of a linear problem - to be inserted in ->plot2d
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):


linopt::plot_data	:=
proc(A,var)

// Eingabe: lineares Optimierungsproblem, wie fuer -> linopt::Tableau, die
//          beiden Variablen von A als Liste 
// Ausgabe: Eine Beschreibung eines Bildes des zulaessigen Bereiches von A


  local corners,	/*allcorners,*/	// Rueckgabe von ->corners, einmal mit und
                  // einmal ohne Logic. Bei corners ist das Problem vorher
                  // etwas modiziziert, und zwar indem zusaetzliche
                  // Restriktionen Minx<= x<= Maxx (y analog) eingefuehrt
                  // wurden. Falls das Problem unbeschraenkt ist, wird so
                  // auf jeden Fall ein geschlossenes Polygon gefunden 		
  bestcornerval,cornerlist,cornerset,	// Komponenten der Rueckgabe
                                       // von ->corners				
  minX,maxX,minY,maxY,	// Rahmen, in dem gezeichnet wird					
  i,j,					   // Laufvariablen								
  /*a,*/					   // Bezeichner								
  B,					      // modifiziertes Optimierungsproblem A		
  lineseq,					// Sequenz der zu zeichnenden Linien, jeweils
                        // Rueckgabe von ->plot_line	
  raster,				   // Ganzzahlige Punkte im Hintergrund; gibts nur fuer
                        // kleine Werte!	
  Xrange,Yrange,		   // MaxX-MinX, y analog							
  objfct;				   // Gerade orthogonal zum Zielfunktionsvektor				
  
begin
  if testtype(A[1],DOM_LIST) then
    A[1] := {A[1][i]$ i=1..nops(A[1])}
  end_if:
  
  if nops(A) = 4 then delete A[4] end_if:
  
  /*if nops(var)=1 then
     a := genident("Y"):
     A[1] := A[1] union {a>=-1, a<=1}:
     var := append(var,a)
   end_if:*/
  
  if nops(indets(A[1]) union indets(A[2])) > 2 then error("Plotting Area is only possible in two dimensions!") end_if:
  
  corners := linopt::corners(A,var,Logic):
  
  if corners = {} or corners[1] = {} then
    print(" No feasible corners found! Feasible Area is empty! "):
    return()
  end_if:
  
  cornerset := corners[1]:
  bestcornerval := corners[2]:
  
  minX := min(op(cornerset,[i,1])$ i=1..nops(cornerset)):
  maxX := max(op(cornerset,[i,1])$ i=1..nops(cornerset)):
  minY := min(op(cornerset,[i,2])$ i=1..nops(cornerset)):
  maxY := max(op(cornerset,[i,2])$ i=1..nops(cornerset)):
  
  if minX = maxX
    then if maxY=minY
           then maxX := maxX+1:
           maxY := maxY+1:
           minX := minX-1:
           minY := minY-1
         else minX := minX-(maxY-minY)/10:
           maxX := maxX+(maxY-minY)/10
         end_if
  elif maxY=minY then
    minY := minY-(maxX-minX)/10:
    maxY := maxY+(maxX-minX)/10
  end_if:
  
  Xrange := -minX+maxX:
  Yrange := -minY+maxY:
  
  B := A:
  B[1] := B[1] union {var[1]<=ceil(maxX+Xrange/5),var[1]>=floor(minX-Xrange/5),
                   var[2]<=ceil(maxY+Yrange/5),var[2]>=floor(minY-Yrange/5)}:
  
  cornerlist := linopt::arrange_corners(linopt::corners(B,var)[1]):
  
  lineseq := linopt::plot_line(op(A[1],[i,1])-op(A[1],[i,2]),var,
                               minX-Xrange/10,maxX+Xrange/10,minY-Yrange/10,
                               maxY+Yrange/10)
  $ i=1..nops(A[1]):
  
  if A[2] <> 0
    then objfct := linopt::plot_line(A[2]-bestcornerval,var,
                                     minX-Xrange/10,maxX+Xrange/10,
                                     minY-Yrange/10,maxY+Yrange/10)
  else objfct := null()
  end_if:
  
  
  
  if testtype(objfct, plot::Line2d) then
    objfct::LineWidth :=0.2;
    objfct::LineStyle :=Dashed;
    objfct::Color := RGB::Red;
  end_if:
  
  if max(7*Xrange/5, 7*Yrange/5) > 14 //100
    then raster := plot::PointList2d([[minX-Xrange/10,minY-Yrange/10,
                                       [1.0,1.0,1.0]],
                                      [maxX+Xrange/10,maxY+Yrange/10,
                                       [1.0,1.0,1.0]]])
  else raster := plot::PointList2d([(([i,j,[0.3,0.3,0.3]]
                              $ i=floor(minX-Xrange/10)..ceil(maxX+Xrange/10))
                             $ j=floor(minY-Yrange/10)..ceil(maxY+Yrange/10))])
  end_if:
  
  plot::Group2d(
                Header = "Maximize ".expr2text(A[2]),
                Axes = Origin,
                AxesTips = TRUE,
                AxesTitles = ["".var[1]."-axis","".var[2]."-axis"],
                PointSize = 1.5,
                PointStyle = FilledCircles,
                BackgroundColor = RGB::White,
                
                lineseq, objfct, raster,
                plot::Polygon2d([[cornerlist[i][1],
                                  cornerlist[i][2],
                                  [0.0,0.9,1.0]]$ i=1..nops(cornerlist)],
                                Filled=TRUE,
                                FillPattern=Solid,
                                LineColor=RGB::Black,
                                Closed=TRUE,
                                Color=[0.0,0.9,1.0]))
  
end_proc:
				
unalias(Tableau):
unalias(Heap):
