//    

// kg, 18/07/94 

/*++
listlib::insert -- inserts an element into an ordered list

insert(l, e [, less])

e    - element to insert
l    - ascending ordered list
less - order function (optional)

Inserts 'e' into the ascending ordered list 'l' according to the order
function 'less'.

less(a,b) must return TRUE iff a < b according to the order of the
list elements of 'l'.

If 'less' is not defined _less is used instead.
++*/

listlib::insert:= proc(l, e, less = _less)
  local lb, ub, mid;
begin
  if args(0) < 2 or args(0) > 3 then 
    error("wrong no of args") 
  end_if;
  if domtype(l) <> DOM_LIST then 
    error("not a list")
  end_if;
  
  ub:= nops(l);
  if ub = 0 then 
    return([e]) 
  end_if;
  
  // is e < min(l) or e > max(l) or ub = 1 ? 
  if less(e, l[1]) then
    return([e, op(l)])
  end_if;
  if less(l[ub], e) or ub = 1 then
    return(append(l, e))
  end_if;
  
  // search for position of e (binary search) 
  lb:= 1;
  while ub > lb do
    mid:= (ub + lb) div 2;
    if less(l[mid], e) then
      lb:= mid+1
    else
      ub:= mid
    end_if
  end_while;
  
  // insert e into list 
  [ op(l, 1..(ub-1)), e, op(l, ub..nops(l)) ]
end_proc:

// end of file 
