//   

/*++
kamo, 1.11.94

listlib::insertAt(L,M,n)

L - list
M - arbitrary MuPAD object
n - integer in 1..nops(L)
	
insertAt inserts M into the list L before the n-th element of L. 
If M is a list, all elements of M are inserted.
If n < 1 then M is inserted before the first element of L.
If n > nops(L) then M is appended to L.
++*/

listlib::insertAt:= proc(L, M, n = 0)
begin
  if args(0) < 2 or args(0) > 3 then 
    error("wrong number of arguments");
  end_if;
  if not testtype(L, DOM_LIST) then
    error("first argument must be a DOM_LIST!");
  elif not testtype(n, DOM_INT) then
    error("third argument must be a DOM_INT!");
  end_if;
  if n < 1 then
    if testtype(M, DOM_LIST) then
      M.L
    else
      [M].L
    end_if;
  elif n > nops(L) then
    if testtype(M, DOM_LIST) then
      L.M
    else
      L.[M]
    end_if;
  else
    if testtype(M, DOM_LIST) then
      [op(L, 1..(n-1))].M.[op(L, n..nops(L))];
    else
      [op(L, 1..(n-1))].[M].[op(L, n..nops(L))];
    end_if;
  end_if;
end_proc:

