/*
Merging of two ordered list.
If third argument is given, it is used for comparing elements.
Otherwise _less is used.
*/

listlib::merge:=
proc(l1:DOM_LIST, l2:DOM_LIST, comp = _less) : DOM_LIST
  local res,i,k;
begin
  if args(0) < 2 or args(0) > 3 then 
    error("wrong number of arguments"); 
  end_if;
  
  // trivial cases 
  i := nops(l1);
  k := nops(l2);
  if l1=[] then 
    return(l2)
  elif l2=[] then 
    return(l1)
  elif comp(l1[i],l2[1]) then 
    return(l1.l2)
  elif comp(l2[k],l1[1]) then 
    return(l2.l1)
  end_if;
  
  res := [0 $ i+k];
  i := 0;
  while l1<>[] do
    if l2=[] then
      return([op(res,1..i)].l1);
    end_if;
    while l2<>[] and comp(l2[1],l1[1]) do
      i := i+1;
      res[i] := l2[1];
      delete l2[1];
    end_while;
    if l2=[] then 
      next;
    end_if;
    i := i+1;
    res[i] := l1[1];
    delete l1[1];
  end_while;
  if l2<>[] then 
    [op(res,1..i)].l2;
  else
    res;
  end_if;
end_proc:

// end of file 
