/*++
removeDuplicates removes duplicate elements of a list.
Note that if several identical elements are contained in a list,
the *last* one of these is kept.
++*/

listlib::removeDuplicates := 
proc(l : DOM_LIST, order = null()) : DOM_LIST
  local i, Nops;
begin
  if order <> null() and order <> hold(KeepOrder) then
    error("unknown Option '".expr2text(order)."'");
  end_if;
  Nops := nops(l);
  if order = hold(KeepOrder) then
    zip(l, [bool(contains(l,op(l,i))=i) $ i = 1..Nops], (x,y) -> if y then x else null() end);
  else
    l := [op(l,Nops-i) $ i = 0..Nops-1];
    l := zip(l, [bool(contains(l,op(l,i))=i) $ i = 1..nops(l)], (x,y) -> if y then x else null() end);
    Nops := nops(l);
    [op(l,Nops-i) $ i = 0..Nops-1];
  end_if;
end_proc:
