/*++
removeDupSorted does the same as removeDuplicates but it assumes that the
list is sorted and is thus faster. A notable gain will, however, only
occur, if there are comparatively few duplicates in a long list. 
++*/

listlib::removeDupSorted := proc(l:DOM_LIST) : DOM_LIST
  local k,n;
begin
  k := 1;
  n := nops(l);
  while k<n do
    if l[k]=l[k+1] then
      delete l[k];
      n := n-1;
    else
      k := k+1;
    end_if;
  end_while;
  l;
end_proc:



