/*++
"Lifts" the minus operation from sets to lists. If one of the arguments is
a list, the result will be a list. However, no guarantee is given for the
ordering of the arguments in the list.
++*/

listlib::setDifference :=
proc(l1,l2)
begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  end_if;
  if (contains([DOM_LIST,DOM_SET],domtype(l1))=0) or
     (contains([DOM_LIST,DOM_SET],domtype(l2))=0) then
    error("illegal type of argument");
  end_if;
  if (domtype(l1)=DOM_LIST) or (domtype(l2)=DOM_LIST) then
    [op({op(l1)} minus {op(l2)})];
  else 
    l1 minus l2;
  end_if;
end_proc:

// end of file 
