/*++
singleMerge merges two lists ignoring duplicates, i.e.
	singleMerge([1,2,3,5],[1,3,4,5]) = [1,2,3,4,5].
It is assumed that the two lists do not contain duplicates!
++*/

listlib::singleMerge := 
proc(l1:DOM_LIST, l2:DOM_LIST, comp = _less) : DOM_LIST
  local res:DOM_LIST, i:DOM_INT;
begin
  res := [ 0 $ nops(l1)+nops(l2) ];
  i := 0;
  while l1<>[] do
    while l2<>[] and comp(l2[1],l1[1]) do
      i := i+1;
      res[i] := l2[1];
      delete l2[1];
    end_while;
    while l2<>[] and l2[1]=l1[1] do
      delete l2[1];
    end_while;
    if l2=[] then 
      break;
    end_if;
    i := i+1;
    res[i] := l1[1];
    delete l1[1];
  end_while;
  
  if l1<>[] then 
    [op(res,1..i)].l1;
  elif l2<>[] then 
    [op(res,1..i)].l2;
  else 
    [op(res,1..i)];
  end_if;
end_proc:

