// 
//
// generic addpattern routine
//
// this routine assumes that everything has been 
// matchlib::block()ed already
// patterns should be a list of lists, with each inner list
// being [pattern, result, vars, piecewise_conditions,
//  hard_conditions] and f_generalize gets a pattern in the
// form [pat, [pw_cond, result], hard_cond] where pattern
// variables are marked by sitting in `##` in the first
// argument.  It should return a (sequence of) list(s) of the
// same form.

matchlib::addpatterns := 
proc(name_of_FSA, name_of_list, patterns, f_generalize,
         split_by_size, split_by_fn)
option hold;
local fn, res, t, i;
begin
  patterns := context(patterns);
  split_by_size := context(split_by_size);
  split_by_fn := context(split_by_fn);
  patterns := map(patterns, matchlib::addpatterns::changenames@
                                matchlib::addpatterns::protect_sums_n_prods);
  context(hold(sysassign)(name_of_list, hold(_concat)(name_of_list,patterns)));

  patterns := listlib::removeDuplicates(map(context(name_of_list),
                   matchlib::addpatterns::specialcases));

  patterns := map(patterns, matchlib::addpatterns::cond2list, TRUE);

  patterns := listlib::removeDuplicates(map(patterns, context(f_generalize)));

  if split_by_fn = FAIL then
    if split_by_size = FALSE or split_by_size < 2 then
      context(hold(sysassign)(name_of_FSA, matchlib::compile::toFSA(patterns)));
    else
      res := [patterns[i..min(i+split_by_size-1, nops(patterns))] 
              $ i = 1..nops(patterns)-1 step split_by_size];
      context(hold(sysassign)(name_of_FSA, map(res, matchlib::compile::toFSA)));
    end;
  else
    t := table();
    patterns := {op(patterns)};
    for fn in split_by_fn do
      if type(fn)=DOM_LIST then
        t[fn[1]] := select(patterns, p -> fn[2](p));
        patterns := patterns minus t[fn[1]];
      else
        t[fn] := select(patterns, p -> hastype(p[1], fn));
        patterns := patterns minus t[fn];
      end_if;
    end_for;
    t[hold(Default)] := patterns;
    t := select(t, e->nops(e[2])>0);
    if split_by_size = FALSE or split_by_size < 2 then
      context(hold(sysassign)(name_of_FSA, map(t,
                       s -> matchlib::compile::toFSA([op(s)]))));
    else
      context(hold(sysassign)(name_of_FSA, map(t,
            proc(s)
              local l, res, i;
            begin
              l := [op(s)];
              res := [l[i..min(i+split_by_size-1, nops(l))]
                      $ i = 1..nops(l)-1 step split_by_size];
              map(res, matchlib::compile::toFSA)
            end)));
    end;
  end;
  null();
end:

matchlib::addpatterns := funcenv(matchlib::addpatterns):

matchlib::addpatterns::dowithresult :=
proc(res, f_cond, f_res)
begin
  if domtype(res) = DOM_LIST then
    [f_cond(res[1]), f_res(res[2])];
  else
    [TRUE, f_res(res)]
  end_if;
end_proc:


// some pattern results contain symbolic sums and products.
// transform them s.t. no collisions with identifiers can occur:
matchlib::addpatterns::protect_sums_n_prods :=
proc(p)
  local res, fn, sums, s, si;
begin
  res := p[2];
  for fn in [[hold(sum), hold(sum::sum_fn)],
             [hold(product), hold(product::prod_fn)]] do
    sums := select([prog::find(res, fn[1])], p -> p[-1]=0);
    while sums <> [] do // can't do for s in sums because of nested sums
      s := sums[1];
      // can't do indefinite sums
      assert(testtype(op(res, s[1..-2].[2]), "_equal"));
      si := op(res, s[1..-2].[2,1]);
      assert(domtype(si) = DOM_IDENT);
      res := subsop(res, s[1..-2] = subs(`#f`(`#a`, `#b`),
                                         [`#f` = fn[2],
                                          `#a` = fp::unapply(op(res, s[1..-2].[1]), si),
                                          `#b` = op(res, s[1..-2].[2,2])]), Unsimplified);
      sums := select([prog::find(res, fn[1])], p -> p[-1]=0);
    end;
  end;
  p[2] := eval(hold(matchlib::block)(res));
  p;
end_proc:


// change user-given pattern vars to `##`(`#a`) etc.,
// taking care of x^(-a) to match x^(-5) and similar
matchlib::addpatterns::changenames :=
proc(pat)
local var, vars, pvar, mvar, i;
begin
  vars := pat[3];
  delete pat[3];
  for var in vars do
    if var in {`#undefined`, `#matchlib::block`} then
      break ;
    end_if:
    pvar := `#`.var;
    mvar := `#-`.var;
    i := 0;
    while has(pat, {pvar,mvar}) do
      i := i+1;
      pvar := `#`.var.i;
      mvar := `#-`.var.i;
    end;
    pat[1] := subs(pat[1], -var=`##`(mvar), var=`##`(pvar));
    if has(pat[1], pvar) then
      pat[2..3] := subs(pat[2..3], var=pvar);
      if has(pat[1], mvar) then
        pat[4] := subs(pat[4], var=pvar).[-mvar=pvar];
      else
        pat[4] := subs(pat[4], var=pvar);
      end_if;
    else
      pat[2..4] := subs(pat[2..4], var=-mvar);
    end;
  end;
  pat;
end:

// special cases: `##`(`#a`)*x should match x,
// same for + and ^:

matchlib::addpatterns::specialcases :=
proc(pattern)
  local evalsubsts, substsaftereval, additional, add_pat, target, vars;
begin
   // for unblocking, these should be deactivated:
   evalsubsts := [hold(sum::sum_fn)=`#sum_fn`,
                  hold(sum::evalAtPoint)=`#evalAtPoint`,
                  hold(sum)=`#sum`,
                  hold(product::prod_fn)=`#prod_fn`,
                  hold(product)=`#product`,
                  hold(fact)=`#fact`,
                  hold(int::addpattern::rewriteToDiff)=`#rewriteToDiff`,
                  hold(int::addpattern::rewriteToD)=`#rewriteToD`,
                  hold(int)=`#int`,
                  hold(binomial)=`#binom`,
                  hold(intlib::tryChangeVar)=`#tryCV`,
                  hold(hold)=`#hold`,
                  hold(evalAt)=`#evalAt`,
                  hold(testtype)=`#testtype`,
                  hold(iszero)=`#iszero`,
                  hold(has)=`#has`,
                  hold(bool)=`#bool`,
                  hold(diff)=`#diff`,
                  hold(Simplify)=`#Simplify`,
                  hold(intlib::Simplify)=`#iSimplify`,
                  hold(simplify)=`#simplify`,
                  hold(piecewise)=`#piecewise`,
                  infinity=`#infinity`,
                  -infinity=`#-infinity`,
                  hold(infinity)=`#infinity`,
                  hold(transform::invztrans)=`#transform::invztrans`,
                  hold(kroneckerDelta) = `#kroneckerDelta`,
                  hold(transform::ztrans)=`#ztrans`,
                  hold(transform::ztrans::evalAtPoint)=`#ztrans::evalAtPoint`,
                  hold(transform::laplace::evalAtPoint)=`#laplace::evalAtPoint`,
                  hold(transform::ztrans::mult2diff)=`#mult2diff`,
                  hold(specfunc::Wurzelbehandlung)=`#specfunc::Wurzelbehandlung`]:
   evalsubsts := map(evalsubsts, 
                         x -> x[1] =
                           if has(pattern, x[2]) then
                             genident("".x[2])
                           else x[2]
                           end);
   // undo the change:
   substsaftereval := map(evalsubsts, x -> op(x,2)=op(x,1)):
  
   additional := {};
   add_pat :=
   proc(pat, vars)
     local pos, v, vneg, p, set, e, t, value, do_unbl;
   begin
     if nops(vars) = 0 then return(); end;
     v := op(vars, 1);
     vars := vars minus {v};
     set[0] := FALSE;
     set[1] := FALSE;
     set[exp(1)] := FALSE;
     pos := [prog::find(pat[1], v)];
     for p in pos do
       if nops(p) = 0 then next; end;
       case op(pat[1], p[1..-2].[0])
         of hold(_mult) do set[1] := TRUE; break;
         of hold(_plus) do set[0] := TRUE; break;
         of hold(_power) do
	   set[1] := TRUE; set[0] := TRUE;
	   if p[-1]=1 then
	     set[exp(1)] := TRUE;
	   end_if;
       end_case;
     end_for;
     do_unbl := e -> misc::maprec(e, 
        	   {matchlib::block} = (ex -> subs(matchlib::block(1), 
                                                   1=eval(do_unbl(matchlib::unblock(ex))))));
     for value in map([op(set)], op, 1) do
       if set[value]=TRUE then
         // substitute both `##`(`#a`) (pattern) and `#a` (everything else)
         // and don't forget `#-a`
         vneg := "".op(v,1);
         if vneg[2] = "-" then
           vneg[2..2] := "";
         else
           vneg[2..1] := "-";
         end_if;
         vneg := hold(``).vneg;
        traperror((
                   e := subs(pat, v=value, op(v,1)=value,
                                    `##`(vneg)=-value, vneg=-value,
                                    EvalChanges);
                    // simplification
                    e := do_unbl(e);
                    if not contains(e[3].e[4], FALSE)>0 then
                      e[3] := select(e[3], _unequal, TRUE);
                      e[4] := select(e[4], _unequal, TRUE);
                      t := additional union {e};
                      additional := t;
                      add_pat(e, vars);
                    end_if;
                   ));
       end_if;
     end_for;
     add_pat(pat, vars);
     null();
   end_proc:
   vars := map({prog::find(pattern, `##`)},
               p -> if p[-1]=0 then op(pattern, p[1..-2]) else null() end);
   add_pat(subs(pattern, evalsubsts), vars);
   
   // add some rewritten forms -- see bug report #1588
   for target in [sincos] do
     additional := additional union
                 map(additional,
                     x -> [rewrite(x[1], target)].x[2..-1]);
   end_for:
   
   // remove special cases where the conditions simply can't be fulfilled
   // note that has et al. are still blocked!
   additional := select(additional,
      proc(pat)
        local res;
      begin
        _lazy_or(nops(pat) = 2,
                 has(pat[3], hold(`#testtype`)),
                 traperror((res := is(_and(op(matchlib::unblock(pat[3])))))) <> 0,  
                 res <> FALSE,
                 if nops(pat) > 3 then
                   _lazy_or(traperror((res := is(_and(op(matchlib::unblock(pat[4])))))) <> 0,
                            res <> FALSE)
                 else
                  FALSE
                 end);
      end_proc):
   
   // evaluate conditions not depending on free variables
   additional := map(additional,
      proc(pat)
      begin
        if nops(pat) < 3 then pat else
           pat[3] := map(pat[3],
              cond -> if indets(cond) = {} then 
                        is(subs(matchlib::unblock(cond), substsaftereval, EvalChanges))
                      else cond
                      end_if);
           pat[3] := select(pat[3],
                            x -> x <> TRUE and x <> matchlib::block(TRUE));
           if contains(pat[3], FALSE)>0 or
              contains(pat[3], matchlib::block(FALSE)) > 0
           then null() else pat end_if
         end_if;
      end);  
      
   // remove those where vars got lost
   // First remove conditions of has(var, _X) and not has(var, _X)
   // from the conditions of the pattern because these conditions
   // does not have a meaning for the validity of the pattern
   // conditons gioven in con have a form like:
   // array(1..2, (1) = `#matchlib::block`, (2) = not #has(#b, _X))
   additional := select(additional,
     pat -> (indets([op(pat[2..3]),
             select(pat[4],
     con ->  (case op(con,[2,0])
               of hold(`#has`) do
                 if op(con,2) = hold(_X) then
                   return(FALSE) ;
                 end_if:
                 break;
               of hold(_not) do
                 if op(con,[2,1,0]) = hold(`#has`) then
                   if op(con,[2,1,2]) = hold(_X) then
                   return(FALSE);
                   end_if:
                 end_if:
                 break;
               end_case:
              TRUE;) ) ])
                 intersect map(vars, op, 1)) minus indets(pat[1]) = {});

   additional := subs(additional, substsaftereval);

   pattern, op(additional);
end:


// mini-piecewise instead of matcher condition
matchlib::addpatterns::cond2list :=
(p) -> [p[1], [(matchlib::block@(x->x))(hold(_and)(op(p[3]))), p[2]], p[4]]:


// the typical thing to do with results is to make a piecewise object
matchlib::addpatterns::handle_results :=
proc(F)
  local i, F2;
begin
  if F = [] then return(FAIL); end_if;
  userinfo(10, "potential matches: ".expr2text(F));
  // use recursive formulas only if there is nothing else left
  F := subs(F, hold(int::addpattern) = `#int::addpattern`, Unsimplified);
  F := split(F, has, [hold(int),
                      hold(sum),
                      hold(product),
                      hold(intlib::tryChangeVar), hold(intlib::intfn),
                      hold(transform)]);
  F := map(F, subs, `#int::addpattern` = hold(int::addpattern), Unsimplified);

  for i from 2 downto 1 do
    F[i] := map(F[i], matchlib::unblock);

    repeat
      F2 := F[i];
      F[i] := map(F2,
                  ex -> if traperror((ex[1] := eval(matchlib::unblock(ex[1])))) = 0
                              then ex else null(); end);
    until F[i] = F2 end_repeat;

    F[i] := map(F[i],
                proc(e)
                  local ie;
                begin
                  if e[2] = undefined then
                    return(null());
                  end_if;
                  ie := is(e[1]);
                  if ie = FALSE then
                    null();
                  elif ie = TRUE then
                    [TRUE, e[2]]
                  else
                    e
                  end_if;
                end_proc);

    if F[i] <> [] then
      // any result which is not a piecewise object?
      F[i] := split(F[i], ex -> _lazy_and(ex[1]=TRUE,
                                          not hastype(ex[2], piecewise)));
      if F[i][1] <> [] then
        F[i][1] := map(F[i][1], op, 2);
        repeat
          F2 := F[i][1];
          F[i][1] := map(F2,
                         ex -> if traperror((ex := eval(matchlib::unblock(ex)))) = 0 and
                                  ex <> undefined and ex <> FAIL
                              then ex else null(); end);
        until F[i][1] = F2 end_repeat;
        if F[i][1] <> [] then
          F[i][1] := prog::sort(F[i][1], Simplify::defaultValuation);
          userinfo(5, "Found matches: ".expr2text(F[i][1]));
          return(F[i][1][1]);
        end;
      end_if;
      F[i] := F[i][2];
    end_if;
    repeat
      F2 := F[i];
      F[i] := map(F2,
                  ex -> if traperror((ex := eval(matchlib::unblock(ex)))) = 0 and
                           ex[2] <> undefined and ex <> FAIL 
                              then ex else null(); end);
    until F[i] = F2 end_repeat;

  end_for;
      
  F := map(F[2].F[1],
       r -> if traperror((r := eval(matchlib::unblock(r)))) = 0
                  then r else null() end_if);
  F := map(F,
       r -> if traperror((r := map(r, eval@matchlib::unblock))) = 0
                  then r else null() end_if);
  if F = [] then return(FAIL); end_if;
  F := piecewise(op(F));
  if F = undefined then
    F := FAIL 
  end_if;
  return(F);
end_proc:
