// 

// Compile many-to-one AC matching to MuPAD code.

// Uses: Match::PrefixTree.

matchlib::compile :=
funcenv(proc()
	  local FSA;
	begin
	  FSA := matchlib::compile::toFSA(args());
	  subs(x -> matchlib::evalFSA(x, `#FSA`),
	       `#FSA` = FSA);
	end_proc):

// linearise the pattern w.r.t. pattern vars
// TODO: constant identifiers
matchlib::compile::_rename_pattern_vars :=
proc(pattern, result, conditions = [])
  local seen, changed_pattern ;
begin
  seen := table();
  changed_pattern :=
  misc::maprec(pattern,
               {"function"}
               = proc(ex)
                   local ident, new_name;
		 begin
		   if op(ex, 0) = `##` then
		     ident := op(ex, 1);
		     if contains(seen, ident) then
		       new_name := genident(//"#pat_" .
					    stringlib::remove(expr2text(ident), "`") .
					    "_");
		       conditions := conditions . [new_name = ident];
		       return(`##`(new_name, op(ex, 2..-1)));
		     else
		       seen[ident] := TRUE;
		     end_if;
		   end_if;
		   return(ex);
               end_proc);

  changed_pattern, result, conditions;
end_proc:

matchlib::compile::toFSA :=
proc(patterns)
  local tree, i;
begin
  if not testtype(patterns,
		  Type::ListOf(Type::ListOf(Type::AnyType, 2, 3)))
    then error("Patterns must be given as list of lists.");
  end_if;
  if nops(patterns) < 1 then
    error("No patterns given."):
  end_if;
  tree := matchlib::PrefixTree(matchlib::compile::_rename_pattern_vars(op(op(patterns,1))));
  for i from 2 to nops(patterns) do
//    fprint(Unquoted, 0, "[A".expr2text(i)."  ".expr2text(time()));
    tree := matchlib::PrefixTree::closure_union(tree,
						matchlib::PrefixTree(matchlib::compile::_rename_pattern_vars(op(op(patterns, i)))));
  end_for;
//  fprint(Unquoted, 0, "");
  matchlib::PrefixTree::toTable(tree);
end_proc:


