// andi, 01.12.94 

/*++
clean  - Remove recursions in module domains

clean( mdomain )

mdomain - module domain
++*/
                                             
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNCTION: clean ( domain : DOM_DOMAIN ) : DOM_NULL                           
//                                                                              
// Diese Funktion erwartet ein Domain eines Moduls  und substituiert jeweils im 
// ersten EXEC-Knoten der Funktionsumgebung einer Modulfunktion  den 5-ten Ein- 
// trag (Rueckverweis auf das gegebene Domain) durch den Wert NIL.              
//                                                                              
// Damit werden die Zyklen dieser Datenstruktur aufgeloest  und das Domain kann 
// von der Speicherverwaltung (auch ohne Garbage Collection) vollstaendig frei- 
// freigegeben werden.                                                          
//                                                                              
// Wenn im Zusammenhang mit der Verwendung  von Modulen  nach Speicherlecks ge- 
// sucht wird, dann sollte vor dem Verlassen von MuPAD jedes zuvor geladene Mo- 
// dul mit clean "gesaeubert" werden. Nur so kann eine korrekte Speicherstatis- 
// tik erwartet werden.                                                         
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module::clean:= proc( _domain_ )
local   _domop_, _nam_, _exec_;
begin
	if( domtype(_domain_) <> DOM_DOMAIN ) then
		error( "Illegal argument" );
	end_if;
	for _domop_ in op(_domain_) do
		_nam_:= op(_domop_,1);
		if( domtype(_nam_) <> DOM_STRING ) then next;
		end_if;
		_exec_:= op(_domop_,[2,1]);
		if( domtype(_exec_) <> DOM_EXEC  ) then next;
		end_if;
		if( op(_exec_,5) <> _domain_ ) then next
		end_if;
		slot(_domain_,_nam_):= subsop(slot(_domain_,_nam_),[1,5]=NIL);
	end_for;
	null();
end_proc:

