//    

// andi, 13.05.94 

/*++
stat - Print out the state of module management

stat( )

This function uses 'stdmod::stat' to get the state of the 
module management. After that, the state will be printed out.

For more information, refer to the help-document of module
'stdmod'.
++*/

module::stat:= proc()
local	bhr, entry, hr, s, tab;
save    PRETTYPRINT;
begin
	PRETTYPRINT:= FALSE;
	bhr:= "============================================================\n";
	hr := "------------------------------------------------------------\n";
	tab:= external("stdmod","stat")();

	print(	Unquoted,
		bhr.
		"M-Path: ".tab["mpath"]."\n".
		hr.
		"Pseudo: ".module::expr2text(tab["psmod"])."\n".
		hr.
		"Kernel: obj = ".module::expr2text(-3,tab["mupad"][1]).
		                 "/".module::expr2text(-4,tab["mupad"][2]).
		                 " | unload=  ".
		( if( tab["mupad"][3] ) then "YES";
		                        else " NO";
		  end_if )."\n".
		hr.
		"Module: loaded = ". module::expr2text(-5 ,tab["modul"][2])." | ".
			"max   = ".  module::expr2text(-4 ,tab["modul"][3])." | ".
			"active = ". module::expr2text(-11,tab["modul"][1])." \n".
		"Aging : ".
		( if( tab["aging"][1]=0 ) 
		  then " is not active | ";
		  else "maxage =".module::expr2text(-6,tab["aging"][1])." | ";
		  end_if ).
		  "itval = ".module::expr2text(-4,tab["aging"][2])." | ".
		  "LRU    =".module::expr2text(-12,tab["aging"][3])."\n".
		hr.
		( s:= ""; 
		  for entry in tab["entry"] do
			s:= s. module::expr2text(10,op(entry,1)).": ".
			"age=".module::expr2text(-6,op(entry,[2,1]))." | ".
			"flags = ".module::expr2text(   op(entry,[2,4]))."\n";
		  end_for; s; ).
		bhr
	);
end_proc:

