//----------------------------------------------------------------
// gtdata(n,digits) -- computes numerical values of the weights   
// and abscissae of Gauss-Tschebyscheff quadrature with n nodes.  
//                                                                
// return value: list of lists [ b , c ],                         
//               where b=[ b[1],..,b[n] ] , c=[c[1],..,c[n]]      
//               are the weights and abscissae auf Gaussian       
//               quadrature:                                      
//               int(f(x),x=0..1)= sum( b[i]*f(c[i]), i=1..n ).   
//                                                                
// With this rule int(g(x)/sqrt(1-x^2),x=-1..1) is integrated     
// exactly for polynomials g(x) through order 2n-1.               
//                                                                
// Example:                                                       
// >>  ([b,c]):= numeric::gtdata(50);                             
//----------------------------------------------------------------
 
numeric::gtdata:=proc(n) local i;option remember;
begin
   if args(0)<>1 then error("expecting one argument") end_if;
   if domtype(n)<>DOM_INT then error("expecting an integer number of nodes") end_if;
   if n<1 then error("expecting a positive number of nodes") end_if;
   [[PI/2/n*sin((2*i-1)*PI/2/n)$ i=1..n],
    [(1+cos((2*i-1)*PI/2/n))/2$ i=1..n]];
 end_proc:
