// 
//       
// 

/*++
	Rounds a floating-point complex number wrt eps,
  	used in newton.mu and in solvepol.mu
++*/

numeric::complexRound := proc(x,eps)
local epsabsx;
begin
   if args(0)<1 then error("expecting at least one argument") end_if;
   if args(0)>2 then error("expecting at most two arguments") end_if;
   if args(0)=1 
      then eps:= 10.0^(-DIGITS) 
      else eps:= float(eps):
           if domtype(eps)<>DOM_FLOAT or eps<10.0^(-DIGITS) then
              error("expecting a real number >= 10^(-DIGITS) as second argument")
           end_if;
   end_if;
   if domtype(x)=DOM_COMPLEX and
      domtype(op(x,1))=DOM_FLOAT and
      domtype(op(x,2))=DOM_FLOAT 
   then
     epsabsx := eps*specfunc::abs(x):
     if specfunc::abs(op(x,1))<epsabsx then return(I*op(x,2)) end_if;
     if specfunc::abs(op(x,2))<epsabsx then return(op(x,1)) end_if;
   end_if;
   return(x)
end_proc:

// end of file 
