/*
    numeric::indets(anyMuPADObject)  

returns a set of all indeterminates. 

Indeterminates are:
   identifiers
   indexed identifiers
   symbolic entries in DOM_POLY 
      + indeterminates of DOM_POLY, e.g.,
         numeric::indets( poly(a, [x])); -->  {x, a}


Not considered as indeterminates:
   Type::ConstantIdents (i.e., PI, ..)
   zero-Operands of objects
   integration variables in numeric::quadrature,
   numeric::int and hold(int)(f(x), x = a..b)
*/

numeric::indets:= proc(a)
   local indetsSet, search;
   begin
     if args(0) = 0 then error("expecting one argument") end_if;
     if a::dom::numericindets <> FAIL then
        return(a::dom::numericindets(args()));
     end_if;
     if args(0)<>1 then error("expecting one argument") end_if;
     indetsSet:= {}: //initialize container for indets

     // recursive search. Adds indets to global indetsSet.
     search:= proc(a)
       name numeric::indets@search;
       local b, i;
     begin
       case type(a)
       of DOM_IDENT do
         indetsSet:= indetsSet union {a};
         return(a); 
       of piecewise do      // important for plot
       of numeric::piecewise do  // important for plot
          search([op(a)]);
          indetsSet:= indetsSet minus {Otherwise};
          return(a)
       of "_index" do
          // indets(x[1]) = {x[1]}
          // indets(x[1][2]) = {x[1],[2]}
          // but
          // indets(f(x)[1]) = {x}
          // indets(f(x)[1][2]) = {x}
          b:= a;
          while type(b) = "_index" do
             b:= op(b, 1);
          end_while:
          if domtype(b) = DOM_IDENT then
             indetsSet:= indetsSet union {a};
             return(a);
          else
             // do not count f(x, y)[1] as an indet,
             // but only x, y
             return(search(b));
          end_if;
          return(a);
       of DOM_POLY do
          indetsSet:= indetsSet union {op(op(a,2))};
          search(map(poly2list(a),op,1));
          return(a);
        
       of DOM_VAR do
          return(a)
       of DOM_PROC do
          // Search the procedure body op(a, 4) for
          // global identifiers. Unfortunately,
          // return(search(op(a, 4)));
          // works only in very simple case. If search is
          // called recursively in the body, everything is
          // messed up completely.
          // indetsSet:= indetsSet union indets(op(a, 4));
          return(a);
       of DOM_FUNC_ENV do
          // op(a, 1) is the procedure relevant
          // for the evaluation. Go directly to
          // the DOM_PROC case via op(a, [1, 4]):
          // return(search(op(a, 1)));
          // Assuming this FUNC_ENV is provided by
          // the system and 'clean' (i.e., no global
          // variables):
          return(a);
       
       of "limit" do
         indetsSet:= indetsSet union (
         numeric::indets([op(a,1),op(a,2)]) minus {op(a,[2,1])}
         );
         return(a);
           
       of "function" do   
          
       // mathematical interpretation of indets: ignore
       // integration variable in unevaluated numeric::quadrature:
         if op(a, 0) = hold(numeric::quadrature) 
           or op(a, 0) = hold(numeric::int) 
         then
           indetsSet:= indetsSet union (
           numeric::indets([op(a,1),op(a,2)]) minus {op(a,[2,1])}
           );
           return(a);
         end_if;
         break
       of "int" do
          if type(op(a, 2)) = "_equal" then
             // do not count x in int(f(x), x = a..b)
             indetsSet:= indetsSet union (
                         numeric::indets([op(a,1),op(a,2)]) minus {op(a, [2, 1])}
                                       )
          else
             // do count x in int(f(x), x)
             indetsSet:= indetsSet union numeric::indets([op(a,1),op(a,2)]);
          end_if;
          return(a);
       of "intOverSet" do
         indetsSet:= indetsSet union numeric::indets([op(a,3)])
         union (numeric::indets([op(a, 1)]) minus {op(a, 2)});
         return(a)
       
       // ignore summation index in unevaluated sum:
       of "sum" do
       of "numeric::sum" do  
          if type(op(a, 2)) = "_equal" or
             type(op(a, 2)) = "_in" then
             // do not count k in sum(f(k), k = a..b)
             indetsSet:= indetsSet union (
                         select(numeric::indets([op(a,1),op(a,2)]), x -> not has(x, op(a, [2, 1])))
                                       )
          else
             // do count k in sum(f(k), k)
             indetsSet:= indetsSet union numeric::indets([op(a,1),op(a,2)]);
          end_if;
          return(a);
      
      of "transform::fourier" do
      of "transform::invfourier" do
      of "transform::laplace" do
      of "transform::invlaplace" do
      of "transform::ztrans" do
      of "transform::invztrans" do   
                
       // ignore original variable of transform objects:
        indetsSet:= indetsSet union (
        numeric::indets([op(a,1), op(a, 3)]) minus {op(a,2)}
        );
        return(a)
        
      of RootOf do 
          // do not count x in RootOf(f(x), x)
        indetsSet:= indetsSet union (
        numeric::indets([op(a,1)]) minus {op(a,2)}
        );
        return(a)
        
      end_case;

      if a::dom::numericindets <> FAIL then
        indetsSet:= indetsSet union a::dom::numericindets(args());
        return(a)
      end_if;
      
      if a::dom::freeIndets <> FAIL then
        indetsSet:= indetsSet union a::dom::freeIndets(args());
        return(a)
      end_if;
      
       // do not enter objects of library domains, there is danger
       // of infinite recursion!
       // Warning!!! Following characterization of kernel objects
       // works in MuPAD 2.0, but not in MuPAD 1.4 !!!!!!
       if domtype(extop(a,0))=DOM_DOMAIN then return(a) end_if;

       // make sure there is no infinite recursion:
       if a=op(a,1) then return(a) end_if;

       // handle expressions and other stuff:
       for i from 1 to nops(a) do search(op(a,i)): end_for;
       
       a
     end_proc:

     //------ main body of numeric::indets ------------
     // treat most common objects first to avoid costs of an
     // unnecessary recursive call to search:
     case domtype(a)
     of DOM_LIST    do 
     of DOM_SET     do
     of DOM_ARRAY   do
     of DOM_TABLE   do map(a, search);
                       return(indetsSet minus Type::ConstantIdents);
     of DOM_HFARRAY do
     of DOM_FLOAT   do 
     of DOM_COMPLEX do 
     of DOM_INT     do 
     of DOM_RAT     do return(indetsSet);
     of Series::Puiseux do
                       search([extop(a, 5), extop(a, 6)]):
                       return(indetsSet minus Type::ConstantIdents);
     of Series::gseries do
                       search([extop(a)]):
                       return(indetsSet minus Type::ConstantIdents);
     end_case;

     // do the recursive search, which fills up indetsSet.
     search(a);
     indetsSet minus Type::ConstantIdents;
   end_proc:
