/* ---------------------------------------------------------------
Utility: 

   the following string as a modified version of the 
   scilab code linsolve.sci in Scilab 2.6 for solving
   the linear system A*x = b with a *sparse* matrix A. 
   This scilab code is used by numeric::linsolve and 
   numeric::matlinsolve, calling it in the form

    f:= scilab::func(["A", "b"],
                     ["x", "kern", "kernindices", "info"],
                     numeric::linsolveSciSparse);
    [x, kern, kernindices, Info] 
       = f(A, b, ReturnTypes = [..., ..., Default, Default]);

    On input of arbitrary matrices A (m x na) and b (m x nb),
    it returns a special solution x (na x nb)  of A*x = b
    together with the kernel (na x kerneldim) of A.

    kernindices is a list of the non-characteristic column 
    indices of A.

    the string Info is
    "EmptyKernel"  (there is a unique solution, the kernel is empty)
    "OK",   (there is a solution, the kernel is not empty)
    "FAIL"  (there is no solution)

Remark:
    scilabs's original code linsolve.sci contains lines such as
        %tol=1.D-10*maxi(abs(A))*max(ma,na);
        [ptr,rkA]=lufact(A, [%tol, 0.001]);
        %tol=1.D-10*maxi(abs(U))*max(ma,na);
        [ptrU,rk]=lufact(U,[%tol,.001]);

   This produces strange problems. E.g., in 
      A = sparse([10^(-10), 0; 1,  10^30]);
      b = [10^30; 10^30];
   the rank of A is returned as 1 instead of 0 and
   a completely wrong answer is returned:
      linsolve(A, b)
      WARNING:Possible Conflicting linear constraints, 
      error in the order of 1.000E+30
      ans  = !   0. !
             ! - 1. !
   With my modifications, we get
      x  = 1.0E+24 * !   1.000E+16 !
                     ! - 1.000E-14 !
   which is a good approximation of the exact solution [10^40, -9999999999].

----------------------------------------------------------------*/

numeric::linsolveSciSparse:=
["function [x, kern, kernindices, info] = mylinsolveSparse(A,b); ".
 "info = 'OK'; ".

 "if type(A) <> 5 then ".
 " A = sparse(A); ".
 "end; ".
 "if type(b) <> 1 then ".
 " b = full(b); ".
 "end; ".

 "normA = norm(A); ".
 "if normA <> 0 then ".
 "  A = A/normA; ".
 "  b = b/normA; ".
 "end; ".

 "complex = %f; ".
 "ImA = imag(A); ".
 "A = sparse(real(A)); ".
 "Imb = imag(b); ".
 "b = real(b); ".
 "if (norm(ImA) <> 0) | (norm(Imb) <> 0) then ".
 " complex = %t; ".
 " A = [A, -ImA; ImA, A]; ".
 " b = [b; Imb]; ".
 "end; ".

 "[ma,na]=size(A); ".
 "[mb,nb]=size(b); ".
 "if ma<na then ".
 " A=[A;spzeros(na-ma,na)]; ".
 " b=[b;  zeros(na-ma,nb)]; ".
 "end; ".
 "if ma>na then ".
 "  A=[A,sparse([],[],[ma,ma-na])]; ".
 "end; ".
 "nma=max(na,ma); ".

 "[ptrAb, rkAb] = lufact([A, sparse(b); spzeros(nb, nma + nb)]); ".
 "[ptr,rkA]=lufact(A); ".
 "if rkA <> rkAb then ".
 " x = 0; ".
 " kern = 0; ".
 " kernindices = list(); ".
 " info = 'FAIL'; ".
 " return; ".
 "end; ".
 
 "[P,L,U,Q]=luget(ptr); ".
 "x=lusolve(ptr,b); ".
 "ludel(ptr); ".
 "if ma>na then ".
 " x=x(1:na,:); ".
 "end; ".
 "if complex then ".
 " x = x(1:na/2, :) + x((na/2+1):na, :)*%i; ".
 "end; ".

 "if rkA == na then ".
 " kern = 0; ".
 " kernindices = list(); ".
 " info = 'EmptyKernel'; ".
 " return; ".
 "end; ".
 
 "[ptrU,rkU]=lufact(U); ".
 "Y = [sparse([],[],[rkA,nma-rkA]);speye(nma-rkA,nma-rkA)]; ".
 "kerA=[]; ".
 "for k=1:na-rkA, ".
 " bb=full(Y(:,k)); ".
 " ww=sparse(lusolve(ptrU,bb)); ".
 " kerA=[kerA,ww]; ".
 "end; ".
 "ludel(ptrU); ".
 "kerA=Q'*kerA; ".
 
 "[mk, nk] = size(kerA); ".

 "if ma>na then ".
 " kern=kerA(1:na,:); ".
 "else kern=kerA; ".
 "end; ".

 "if nk == 0 then ".
 " kern = 0; ".
 " kernindices = list(); ".
 " info = 'EmptyKernel'; ".
 " return; ".
 "end; ".

 "if complex then ".
 " na = na/2; ".
 " nk = nk/2; ".
 " kern = kern(1:na, :) + kern((na+1):2*na, :)*%i; ".
 " kern = full(kern); ".
 " [w, rkk] = colcomp(kern); ".
 " kern = kern*w; ".
 " kern = kern(:, (nk+1):2*nk); ".
 " for j = 1:nk, ".
 "  tmp = kern(:, j); ".
 "  nn = norm(tmp); ".
 "  if nn <> 0 then ".
 "   kern(:,j) = tmp/nn; ".
 "  end; ".
 " end; ".
 " kern = rref(kern')'; ".
 "end; ".

 "kernindices = list(); ".
 "count = 1; ".
 "for j=1:nk, ".
 " for i=count:na, ".
 "  if kern(i, j) == 1 & norm(kern(i:i, :)) == 1 then ".
 "   kernindices(size(kernindices) + 1) = i; ".
 "    for k=1:nb, ".
 "     if x(i, k) <> 0, ".
 "      x(:, k) = x(:, k) - x(i, k)*kern(:,j); ".
 "      x(i, k) = 0; ".
 "    end; ".
 "   end; ".
 "   count = i; ".
 "   break; ".
 "  end; ".
 " end; ".
 "end; ".
 "endfunction; ".

 "[x, kern, kernindices, info] = mylinsolveSparse(A, b);"
 ]:
