// numeric::piecewise - the domain of conditionally defined objects

// an object of type numeric::piecewise has as many operands as branches
// each operand is a list [condition, expression]

// the value of the conditional defined function is the first expression
// the condition of which is satisfied
// the expression may be any object
// ----------------------------------------------------------------------

numeric::piecewise:= newDomain("numeric::piecewise"):
numeric::piecewise::create_dom:= hold(numeric::piecewise):
numeric::piecewise::info:= "numeric::piecewise -- the domain of conditionally defined functions":
numeric::piecewise::interface:={
//                     hold(branch),
//                     hold(condition),
                       hold(expression) 
//                     hold(numberOfBranches)
                         }:

//------------------------------------------------------------------------------------------
numeric::piecewise::new:=
proc()
  option hold;
  local result, br, cond, i;
begin
  // convert each argument to branch
  result:=[]; // list of all branches created so far

  for i from 1 to args(0) do
    if traperror((br:= context(args(i)))) <> 0 then
      next
    end_if;
    if testargs() then
      if type(br) <> DOM_LIST then
        error("Illegal argument ".expr2text(args(i)))
      end_if;
    end_if;
        
    if traperror((cond:=bool(br[1]))) = 0 then
      if cond then
        return(br[2])
      end_if
    else // cannot evaluate to boolean
      result:= result.[br]
    end_if
  end_for;
  
  if nops(result) = 0 then
    return(undefined)
  elif nops(result) = 1 and op(result, [1, 1]) = Otherwise then
    return(op(result, [1, 2]))
  else
    return(new(numeric::piecewise, op(result)))
  end_if;
end_proc:

//------------------------------------------------------------------------------------------
numeric::piecewise::convert:=
proc(pw)
begin
  case domtype(pw)
    of numeric::piecewise do
      return(pw)
    of piecewise do
      return(new(numeric::piecewise, op(pw)))
  end_case;
  pw
end_proc:
//------------------------------------------------------------------------------------------
numeric::piecewise::testtype:=
proc(x, T)
  local i;
begin
  if T = numeric::piecewise then
     return(bool(domtype(x) = T));
  end_if;
  assert(type(x) = numeric::piecewise);
  // test whether every operand is of the type T
  // (such as T = Type::Arithmetical)
  for i from 1 to extnops(x) do
    if testtype(numeric::piecewise::expression(x, i), T) = FALSE then
      return(FALSE)
    end_if
  end_for;
  TRUE
end_proc:
//------------------------------------------------------------------------------------------
numeric::piecewise::expression:=
proc(pw:numeric::piecewise, n:DOM_INT)
// returns the expression that is valid if the n-th condition holds 
begin
  (extop(pw,n))[2]
end_proc:
//------------------------------------------------------------------------------------------
numeric::piecewise::subs:=
proc(pw:numeric::piecewise)
  local argv, res;
begin
  argv:= args(2..args(0));
  res := hold(numeric::piecewise::new)(op(
            map([extop(pw)],
                proc(l)
                  local newl;
                begin
                  if traperror((newl:= subs(l, argv))) = 0 then
                    newl
                  else
                    null()
                end_if
              end_proc
          )
      )
  );
  if  contains({argv}, hold(Unsimplified)) then
    res
  else
    eval(res)
  end_if
end_proc:

//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::numberOfBranches:= extnops:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::PWif := funcenv(hold(slot)(numeric::piecewise, "PWif"),
                           builtin(1097, 100, " if ", "numeric::piecewise::PWif")):
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::convert_to:=
proc(x:numeric::piecewise, T:DOM_DOMAIN)
begin
  case T
    of numeric::piecewise do
      return(x)
    of piecewise do
      return(piecewise(extop(x)))
    of DOM_LIST do
      return([extop(x)])
    otherwise
      FAIL
  end_case
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::branch:=
proc(pw:numeric::piecewise, n:Type::PosInt)
begin
  if n > extnops(pw) then
    FAIL
  else
    extop(pw, n)
  end_if
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::condition:=
proc(pw:numeric::piecewise, n:DOM_INT)
// returns the n-th condition 
begin
  (extop(pw,n))[1]
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::setBranch:=
proc(pw: numeric::piecewise, n: DOM_INT, br: DOM_LIST)
begin
  if n < 1 or n > extnops(pw) then
    error("Index out of range: no such branch")
  end_if;
  extsubsop(pw, n = br)
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::evaluate:=
proc(pw)
  local i, result, cond;
begin
  result:=[];
  for i from 1 to extnops(pw) do
    if traperror((cond:= bool(eval(numeric::piecewise::condition(pw,i))))) = 0 then
      if cond then
        return(eval(numeric::piecewise::expression(pw, i)))
      end_if;
    else 
      result:=result.[eval(extop(pw, i))]
    end_if;
  end_for;
  if nops(result)=0 then
    return(undefined)
  elif nops(result) = 1 and op(result, [1, 1]) = Otherwise then
    return(op(result, [1, 2]))
  else  
    new(numeric::piecewise, op(result))
  end_if
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
// conditional::borders(pw, x, range)
// find the set of all "borders"" of a conditional object within
// the given range,
// that is, the set of those x such that in every neighbourhood of x,
// there are numbers falling into two different branches of x
// the conditions of pw must only depend on x!                                          

numeric::piecewise::borders:=
proc(pw, x, range)
  local branchBorders: DOM_PROC,
        i;
begin
  if testargs() then
    if indets([extop(pw)]) minus {x} minus Type::ConstantIdents <> {} then
      error("too many symbols in conditional object")
    end_if
  end_if;
  
  branchBorders:=
  proc(cond): DOM_SET
    local i;
  begin
    case type(cond)
      of "_equal" do
        return(numeric::solve(cond, x = range))
      of "_leequal" do
      of "_less" do
        return(numeric::solve(subsop(cond, 0 = hold(_equal)), x = range))
      of "_and" do
      of "_or" do
        return(_union(branchBorders(op(cond, i)) $i=1..nops(cond)))
      of "_not" do
        return(branchBorders(op(cond, 1)))
    end_case;
    // default:
    {}
  end_proc;
  
  _union(branchBorders(op(extop(pw, i),1)) $i=1..extnops(pw))
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
// consistent with piecewise
numeric::piecewise::expr:= proc(pw)
                  begin
                    hold(piecewise)(op(map([op(pw)], expr)))
                  end:
id:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::print := 
proc(pw)
  local i, nargs;
begin
  if PRETTYPRINT=FALSE then
    hold(numeric::piecewise)([numeric::piecewise::condition(pw,i),
                     numeric::piecewise::expression(pw, i)] $i=1..extnops(pw))
  else
    nargs := extnops(pw);
    hold(numeric::piecewise)(subsop(numeric::piecewise::PWif
                           (hold(dummy),
                            numeric::piecewise::condition(pw, i)),
                           1 = numeric::piecewise::expression(pw, i),
                           Unsimplified)
                    $i = 1..nargs)
  end_if
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
numeric::piecewise::TeX :=
proc(pw)
  local i;
begin
  "\\left\\{\n\\begin{array}{ccl}\n".
  _concat((generate::TeX(numeric::piecewise::expression(pw,i))." & \\text{if} & ".
          generate::TeX(numeric::piecewise::condition(pw, i))."\\\\\n") $i=1..extnops(pw)).
  "\\end{array}\n\\right."
end_proc:
*/
//------------------------------------------------------------------------------------------
/*
// Typesetting output of conditional
numeric::piecewise::Content := 
proc(Out, pw)
  local i;
begin
  Out::Cpiecewise(
              Out::Cpiece(Out(numeric::piecewise::expression(pw, i)), Out(numeric::piecewise::condition(pw, i)))
                         $ i = 1..extnops(pw)
                 )
end_proc:
*/
