//===========================================================
// Calls:
//     numeric::pseudoInverse(A, <ReturnType = t>)
//
// Parameters:
//     A    -- an m x n matrix as an array, an hfarray 
//             or a matrix of category Cat::Matrix
//     t    -- either DOM_ARRAY or DOM_HFARRAY 
//             or matrix or densematrix
//
// Return value: the pseudo inverse as a matrix of the same
//               domain type as the input matrix A, provided
//               no ReturnType = t is specified.
//               Otherwise, the returned matrix is of the
//               specified ReturnType.
//
//
// Not final, yet !!!!
// ToDos: - not checked for complex matrices !!!
//        - HardwareFloat support needs to be implemented.
//        - hfarrays are not properly supported yet.
//===========================================================

numeric::pseudoInverse:= proc(A)
local returnType, m, n, options, identity, i;
save DIGITS;
begin
   if args(0) < 1 then
      error("expecting at least one argument");
   end_if:
   if A::dom::hasProp(Cat::Matrix) = TRUE then
      [m, n]:= A::dom::matdim(A);
   elif domtype(A) = DOM_ARRAY or
        domtype(A) = DOM_HFARRAY then
      if op(A, [0, 1]) <> 2 then
         error("first argument: expecting a 2-dimensional array or hfarray");
      end_if:
      if op(A, [0, 2, 1]) <> 1 or
         op(A, [0, 3, 1]) <> 1 then
         error("the array index ranges must start with 1");
      end_if:
      [m, n]:= [op(A, [0, 2, 2]), op(A, [0, 2, 3])];
   else
      error("expecting an array, an hfarray, or ".
            "a matrix of category 'Cat::Matrix'");
   end_if:

   // Default: the domain type of the pseudo inverse should
   // coincide with the domain type of the input matrix
   returnType:= A::dom: 

   options:= [args(2 .. args(0))];
   if has(options, QRD) then
      options:= subs(options, QRD = null());
   end_if:
   if has(options, SVD) then
      options:= subs(options, SVD = null());
   end_if:
   if has(options, Symbolic) then
      options:= subs(options, Symbolic = null());
   end_if:
   if has(options, ReturnType) then
      options:= op(options);
   else
      options:= op(options), ReturnType = returnType;
   end_if:

   // the SVD mode of numeric::leastSquares does not work well
   // for very low DIGITS. Introduce some guard DIGITS. Make
   // sure, we keep below DIGITS = 15 to enable HardwareFloats 
   // (if available) 
   if DIGITS <= 10 then
      DIGITS:= DIGITS + 5:
   end_if:

   if domtype(A) <> DOM_HFARRAY then
     A:= map(A, float):
   end_if:
   if indets(A) <> {} then
      error("symbolic entries ".expr2text(indets(A))." found");
   end_if:

   identity:= array(1..m, 1..m, [[(0 $ i-1), 1, (0 $ m-i)] $ i = 1..m]):

   numeric::leastSquares(A, identity, SVD, options)[1];
end_proc:
