/*****************************

numlib::cornacchia

solves the equation ax^2 + by^2 = m 
a, b, m  must be relatively prime

This version of Cornacchia's algorithm has been taken from
Abderrahmane Nitaj, L'algorithme de Cornacchia

*/

numlib::cornacchia:=
proc(a: Type::PosInt, b:Type::PosInt, m:Type::PosInt): Type::SetOf(DOM_LIST)
  local sols, t, result, cf, u, v, uold, vold, x, i, sqrtma, sqrtmb;
begin
  if igcd(a, b)<>1 or igcd(b, m)<>1 or igcd(a, m) <> 1 then
    error("Input must be pairwise relatively prime");
  end_if;
  
  sols:= numlib::msqrts(-b/a mod m, m);
  sols:= select(sols, x -> x > m/2);

  sqrtma:= floor(sqrt(m/a));
  sqrtmb:= floor(sqrt(m/b));
  
  result:= {};
  for t in sols do
    cf:= extop(numlib::contfrac(t/m), 1);
    uold:=0; vold:= 1;
    u:= 1; v:= 0;
    i:=0;
    while v <= sqrtmb  and i <nops(cf) do
      i:= i+1;
      // compute the i-1 th rational approximant to cf
      [u, v, uold, vold] := [cf[i] *u + uold, cf[i]*v + vold, u, v];
      x:= t*v - m*u;
      if abs(x) <= sqrtma and v <= sqrtmb then
        result:= result union {[abs(x), v]};
      end_if
    end_while;
  end_for;
  result;
end_proc:
