// Friedrich Schwarz 29.8.1994 

/*--
fromAscii(L) decodes a list of ASCII codes 
L - a list of ASCII-codes

non-printing characters are omitted 
(with exception of \t and \n) 
--*/

numlib::ascii2char:=
  //    0     1    2    3     4     5     6     7     8     9
    [  "",  "",   "",  "",   "",   "",   "",   "",   "", "\t",  //  0 -  9
     "\n",  "",   "","\r",   "",   "",   "",   "",   "",   "",  // 10 -  19
       "",  "",   "",  "",   "",   "",   "",   "",   "",   "",  // 20 -  29
       "",  "",  " ", "!", "\"",  "#",  "$",  "%",  "&",  "'",  // 30 -  39
      "(", ")",  "*", "+",  ",",  "-",  ".",  "/",  "0",  "1",  // 40 -  49
      "2", "3",  "4", "5",  "6",  "7",  "8",  "9",  ":",  ";",  // 50 -  59
      "<", "=",  ">", "?",  "@",  "A",  "B",  "C",  "D",  "E",  // 60 -  69
      "F", "G",  "H", "I",  "J",  "K",  "L",  "M",  "N",  "O",  // 70 -  79
      "P", "Q",  "R", "S",  "T",  "U",  "V",  "W",  "X",  "Y",  // 80 -  89
      "Z", "[", "\\", "]",  "^",  "_",  "`",  "a",  "b",  "c",  // 90 -  99
      "d", "e",  "f", "g",  "h",  "i",  "j",  "k",  "l",  "m",  //100 - 109
      "n", "o",  "p", "q",  "r",  "s",  "t",  "u",  "v",  "w",  //110 - 119
      "x", "y",  "z", "{",  "|",  "}",  "~",  ""                //120 - 127
     ]:


numlib::fromAscii := proc(aList)
  local aTable, i; 
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif domtype(aList) <> DOM_LIST then
    error("argument must be a list of integers");
  elif nops(aList) > 0 then
    if not bool({op(map(aList,domtype))} = {DOM_INT}) then
      error("argument must be a list of integers");
    end_if; 
    if min(op(aList)) < 0 or max(op(aList)) > 127 then
      error("argument must be a list of ASCII-codes (0..127)");
    end_if;
  end_if; 
  aTable := table(i=numlib::ascii2char[aList[i]+1] $ i=1..nops(aList));
  tbl2text(aTable);
end_proc:
