// Friedrich Schwarz 11.3.1994 

/*--
igcdmult - extended Euclidean algorithm for an arbitrary number of integers
igcdmult(a,b,c,...)
a, b, c ... - integers

this function extends the kernel function igcdex
--*/

numlib::igcdmult := proc()
  local d, i, z, j, v;
begin 
  if args(0) = 0 then
    error("at least one argument expected");
  elif not bool({op(map([args()],testtype,Type::Numeric))} = {TRUE}) then
    return(procname(args()));
  elif not bool({op(map([args()],domtype))} = {DOM_INT}) then 
    error("arguments must be integers");
  end_if;
 
  d := 0;
  for i from 1 to args(0) do
    z := igcdex(d,args(i));
    d := z[1];
    for j from 1 to i-1 do
      v[j] := z[2]*v[j];
    end_for;
    v[i] := z[3];
  end_for;
  [d, v[i] $ i = 1..args(0)];
end_proc:

