// Friedrich Schwarz 28.3.1994 

/*--
lambda - Carmichael function
lambda(m)
m - natural number

lambda uses ifactor
--*/

numlib::lambda := proc(m)
  local a, alpha, i;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(m,Type::Numeric) then
    return(procname(args()));
  elif domtype(m) <> DOM_INT or m < 1 then
    error("argument must be a positive integer");
  end_if;

  a := m;
  alpha := 0;
  while modp(a,2) = 0 do
    a := a/2;
    alpha := alpha + 1;
  end_while;
  if alpha = 1 or alpha = 2 then
    alpha := alpha - 1;
  elif alpha > 2 then
    alpha := alpha - 2;
  end_if;
  if a = 1 then
    2^alpha;
  else 
    stdlib::ifactor(a);
    (%[2*i] - 1) * %[2*i]^(%[2*i+1] - 1) $ i = 1..(nops(%)-1)/2;
    ilcm(2^alpha,%);
  end_if
end_proc:

// Stefan Wehmeier, 16.4. 1997 

/*--
Lambda - von Mangoldt function
Lambda(m)
m - natural number

Lambda does *not* use ifactor
--*/

numlib::Lambda := proc(m)
local a;
 
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(m,Type::Numeric) then
    return(procname(args()));
  elif domtype(m) <> DOM_INT or m < 1 then
    error("argument must be a positive integer");
  end_if;

  if isprime(m) then 
    return(ln(m));
  end_if;
  a:=numlib::ispower(m);
  if a=FALSE then
    0;
  elif not isprime(op(a,1)) then
    0;
  else
    ln(op(a,1));
  end_if
end_proc:  


