// Friedrich Schwarz 11.3.1994 

/*--
legendre(a,p) - calculates the Legendre symbol (a | p)
a - integer
p - odd prime

legendre uses numlib::jacobi
--*/

numlib::legendre := proc(a,p)
begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) or not testtype(p,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("1st argument must be an integer");
  elif domtype(p) <> DOM_INT or p = 2 or not isprime(p) then
    error("2nd argument must be an odd prime");
  end_if;
  
  numlib::jacobi(a,p)
end_proc:
