// Cf. www.mersenne.org
// last update: 17.05.2010

/*--
mersenne() returns the list of those primes p for which the pth
Mersenne number 2^p - 1 is prime. 
Today (May 2010) we know 47 such primes.
--*/

numlib::mersenne :=
proc()
local n, all_known_mersenne_primes;
begin
  all_known_mersenne_primes:= 
  [2, 3, 5, 7, 13,
   17, 19, 31, 61, 89,
   107, 127, 521, 607, 1279,
   2203, 2281, 3217, 4253, 4423,
   9689, 9941,11213,19937, 21701,
   23209, 44497, 86243, 110503, 132049,
   216091, 756839, 859433, 1257787, 1398269,
   2976221, 3021377, 6972593, 13466917, 
   20996011, // no. 40,  discovered 2003
   24036583, // no. 41,  discovered 2004
   25964951, // no. 42,  discovered 2005
   30402457, // no. 43,  discovered 2005
   32582657, // no. 44,  discovered 2006
   37156667, // no. 45,  discovered 2008
   42643801, // no. 46,  discovered 2009 
   43112609, // no. 47,  discovered 2008
   null()
   ];
  if args(0) = 0 then 
     return(all_known_mersenne_primes)
  end_if;
  if args(0) = 1 then
    n:= args(1);
    if not testtype(n, Type::Arithmetical) then
       error("expecting an argument of 'Type::Arithmetical'");
    end_if;
    if domtype(n) = DOM_FLOAT then
       n:= round(n):
    end_if;
    if domtype(n) = DOM_INT then
      if n < 1 then
         error("expecting a positive integer");
      end_if;
      if 1 <= n and 
         n <= nops(all_known_mersenne_primes) then
         return(all_known_mersenne_primes[n])
      end_if;
      return(procname(args())):
    end_if;
  end_if;
  if args(0) > 1 then
    error("expecting no more than one argument");
  end_if;
  procname(args()):
end_proc:
