// Friedrich Schwarz 11.3.1994 

/*-- 
moebius - Moebius function mu
moebius(m)
m - natural number
--*/

numlib::moebius :=
proc(m)
  local p;
begin
  if args(0) <> 1 then
     error("wrong number of arguments")
  elif testtype(m, Type::Numeric) and (domtype(m) <> DOM_INT or m < 1) then
     error("argument must be a positive integer")
  end_if;

  if not testtype(m,Type::Numeric) then                 
    return(procname(args()))
  end_if;
                     
  if m = 1 then
    return(1)
  else
    p := numlib::primedivisors(m);
    if _mult(op(p)) = m then
      return((-1)^nops(p));
    else
      return(0);
    end_if
  end_if;
end_proc:

