// Friedrich Schwarz 15.9.1994 


/*----- 
mroots(P,m) - calculates the roots of P modulo m
P - a univariate polynomial over the integers
m - a natural number

output : either the sorted list of all integers a in {0,1,..,m-1} such that
         P(a) = 0 (mod m) or FAIL

mroots   uses mrootsPP for prime power moduli
mrootsPP uses Hensel for lifting roots
mroots   uses ifactor
mrootsPP uses gcd_mod and factor
-----*/

numlib::mroots :=
proc(P: Type::PolyOf(DOM_INT), m: Type::PosInt): DOM_LIST
  local makeLists, w, r, p, i, alpha, q, L, A, j, nvars, S;
  
begin
  if args(0) > 2 then
    error("wrong number of arguments")
  end_if;

  makeLists :=
  proc()
    local X, i, j, k;
  begin
    X := [[args(1)[i]] $ i = 1..nops(args(1))];
    for k from 2 to args(0) do
      X := [(append(X[j], args(k)[i]) $ i = 1..nops(args(k)))
            $ j = 1..nops(X)]
    end_for;
    X
  end_proc:

  if m = 1 then // check before IntMod(m)
    return([0]);
  end_if;

  if (nvars:= nops(op(P, 2))) > 1 then
    // loop over all but one variable
    S:= combinat::cartesianProduct({$0..m-1} $nvars - 1);
    return(_concat
           (
            map(numlib::mroots
                (evalp(poly(P, IntMod(m)),
                       op(P, [2, i]) = op(S, j)[i] $i=1..nvars - 1),
                 m),
                proc(listel)
                begin
                  append(op(S, j), listel)
                end_proc
                )
            $j=1..nops(S)
            )
           )
  end_if;

  if degree(P) = 1 then
    A:= numlib::lincongruence(lcoeff(P),-P(0),m);
    if A = FAIL then
      return([])
    else
      return(A)
    end_if
  end_if;
  
  w := stdlib::ifactor(m);
  r := nops(w) div 2;                     // number of primedivisors of m 
  p := [w[2*i] $ i = 1..r];                 // list of primedivisors of m 
  alpha := [w[2*i+1] $ i = 1..r];                    // list of exponents 
  q := [p[i]^alpha[i] $ i = 1..r]; 
  for i from 1 to r do
    L[i] := numlib::mrootsPP(P,p[i],alpha[i]); // mroots for prime power moduli 
    if nops(L[i]) = 0 then
      return([])
    end_if
  end_for;
  A := makeLists(L[i] $ i = 1..r);
  sort([numlib::ichrem(A[j],q) $ j = 1..nops(A)])
end_proc:
