// Friedrich Schwarz 15.9.1994 
  
/*-----
mrootsPP(P,p,alpha) (to be used in mroots) :
input:
P     -- a univariate polynomial over the integers
p     -- a prime number
alpha -- a natural number
output:
the list of all integers z in {0,1,..,p^alpha -1}
such that P(z) = 0 (mod p^alpha)
-----*/

numlib::mrootsPP :=
proc(P: DOM_POLY, p: DOM_INT, alpha: DOM_INT): DOM_LIST
  local Q, a, i, T, q,  w, a_reg, a_sing, Q1, c, x, n, b_reg, b_sing;
begin
  Q := poly(P,IntMod(p));
  if iszero(Q) then
    a := [i $ i = 0..p-1]
  elif degree(Q) = 0 then
    a := []
  else
    T := op(op(Q,2));
    // we want to achieve
    // q := gcd(Q,poly(T^p - T,IntMod(p)));     
    // ( then q is the product of the different linear factors of Q)
    // but p may be large, hence we have to compute T^p modulo Q
    q:= poly(T, IntMod(p));
    q:= powermod(q, p, Q) - q;
    q:= gcd(Q, q);
    w := factor(q);
    w := Factored::factors(w);
    a := [modp(-w[i](0),p) $ i = 1..nops(w)]
  end_if;
  if nops(a) = 0 or alpha = 1 then
    return(a)
  end_if;
  a_reg := [];
  a_sing := [];
  Q1 := D(Q);
  for x in a do
    c[x] := modp(Q1(x),p);
    if c[x] <> 0 then
      a_reg := append(a_reg,x)
    else
      a_sing := append(a_sing,x)
    end_if
  end_for;
  n := nops(a_reg);
  if n > 0 then                                // lift the roots using Hensel 
    b_reg := [numlib::regularHensel(P,a_reg[i],p,alpha,c[a_reg[i]]) $ i = 1..n]
  else
    b_reg := []
  end_if;
  if nops(a_sing) > 0 then
    b_sing := numlib::singularHensel(P,a_sing,p,alpha)
  else
    b_sing := []
  end_if;
  _concat(b_reg,b_sing)
end_proc:
