// Friedrich Schwarz 15.9.1994 

/*--
msqrts -- calculates square roots modulo m
          
a - an integer (a quadratic residue modulo m)
m - a natural number

msqrts uses ifactor, numlib::sqrtmodp and numlib::hensel2
--*/

// use this to denote that no solution exists (changed from FAIL to []):
alias(fail=[]):

numlib::msqrts :=
proc(a,m)
  local i, n, alpha2, x, y, L, w, r, p, alpha, q, A, j, makeLists;

begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) or not testtype(m,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("1st argument must be an integer");
  elif domtype(m) <> DOM_INT or m < 1 then
    error("2nd argument must be a positive integer");
  elif igcd(a,m) > 1 then
    error("arguments must be relative prime");
  end_if;
  
  makeLists :=
  proc()
    local X, i, j, k;
  begin
    X := [[args(1)[i]] $ i = 1..nops(args(1))];
    for k from 2 to args(0) do
      X := [(append(X[j], args(k)[i]) $ i = 1..nops(args(k)))
            $ j = 1..nops(X)]
    end_for;
    X
  end_proc;
  
  if m = 1 then
    return([0])
  end_if;
  n := m;
  alpha2 := 0; 
  if modp(n,2) = 0 then
    repeat
      n := n div 2;
      alpha2 := alpha2 + 1
    until modp(n,2) = 1
    end_repeat;
    if alpha2 > 2 then
      if modp(a,8) <> 1 then
        return(fail)
      else
        x := numlib::hensel2(a,1,2,alpha2);
        y := numlib::hensel2(a,3,2,alpha2);
        L[2] := [x,y,modp(-x,2^alpha2),modp(-y,2^alpha2)]
      end_if
    elif alpha2 = 2 then
      if modp(a,4) <> 1 then
        return(fail)
      else
        L[2] := [1,3]
      end_if
    else
      L[2] := [1]
    end_if
  end_if;
  if numlib::jacobi(a,n) = -1 then
    return(fail)
  elif n = 1 then
     return(L[2])
  else
    w := stdlib::ifactor(n);
    r := nops(w) div 2;           // number of odd primedivisors of m 
    p := [w[2*i] $ i = 1..r]; // list of odd primedivisors of m   
    alpha := [w[2*i+1] $ i = 1..r];        // list of exponents   
    q := [p[i]^alpha[i] $ i = 1..r];
    for i from 1 to r do
      if numlib::jacobi(a,p[i]) = -1 then
        return(fail)
      else
        x := numlib::sqrtmodp(a,p[i]);     // calculates a root mod p[i] 
        x := numlib::hensel2(a,x,p[i],alpha[i]);    // ... and lifts it 
        L[p[i]] := [x,modp(-x,q[i])]
      end_if
    end_for;
    if alpha2 = 0 then
      A := makeLists(L[p[i]] $ i = 1..r)
    else
      A := makeLists(L[p[i]] $ i = 1..r, L[2]);
      q := append(q,2^alpha2)
    end_if;
    return(sort([numlib::ichrem(A[j],q) $ j = 1..nops(A)]))
  end_if
end_proc:
