// Friedrich Schwarz 11.3.1994 

/*--
numprimedivisors(a) - returns the number of primedivisors of a
a - non-zero integer

numprimedivisors uses ifactor
--*/

numlib::numprimedivisors := proc(a)
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("argument must be an integer");
  end_if;
  if a = 0 then
    0
  else
    nops(stdlib::ifactor(a)) div 2
  end_if
end_proc:

