// von specfunc::phi nach numlib::phi verschoben. Walter, 30.10.99
/*
phi -- Euler phi function

Calling Sequence:   numlib::phi( n )

Parameters: n -- integer not equal to 0

Overloadable: n

Description:
phi calculates the Euler phi function of the argument n , i.e. the number of
numbers smaller than |n| which are relatively prime to n . phi returns an error
if the argument is a number but not an integer unequal to 0. phi returns the
function call with evaluated arguments if the argument is not a number.

Examples:

>> numlib::phi(-7);

      6
*/

numlib::phi:= 
funcenv(proc(x) name numlib::phi; 
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  end_if;
  if x::dom::phi <> FAIL then
     x::dom::phi(x);
   elif testtype(x, Type::Numeric) then
     error("Illegal argument")
   else
     procname(args());
   end_if;
end_proc, builtin(1101, 0, NIL, "numlib::phi"),
  table(
     "info" = "the Euler phi function [try ?numlib::phi for help]",
     "type" = "numlib::phi"
   )
):
