/*--
pollard - Pollard's rho factorization algorithm
pollard(n) or pollard(n,maxit)
n - composite number
returns:
- n if n is said prime by isprime
- g,n/g if a factor g of n is found (g is not necessarily prime)
- FAIL otherwise
maxit=10000 by default (good for factors up to 10^8)
--*/

numlib::pollard := proc(n)
   local maxit,x,y,i,g;
   save SEED; // needed due to use of 'random'
begin
   if args(0) < 1 or args(0) > 2 then
      error("wrong number of arguments");
   end_if; 
   if not testtype(n,Type::PosInt) then 
      error("1st argument must be a positive integer");
   end_if;
   if isprime(n) then 
      return(n);
   end_if;
   if args(0)=2 then 
      maxit:=args(2);
      if not testtype(maxit,Type::PosInt) then 
         error("2nd argument must be a positive integer");
      end_if;
   else 
      maxit:=10000;
   end_if;
   x:=random(n)(); 
   y:=x;
   for i from 1 to maxit do
      x:=x^2+1 mod n;
      y:=y^2+1 mod n; 
      y:=y^2+1 mod n;
      g:=igcd(y-x,n);
      if g<>1 then 
         if g<>n then 
            return(g,n/g);
         end_if 
      end_if;
   end_for;
   FAIL;
end_proc:
