// Friedrich Schwarz 11.3.1994 

/*--
primedivisors(a) - returns the list of primedivisors of a
a - non-zero integer

primedivisors uses ifactor
--*/

numlib::primedivisors := proc(a)
  local i;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("argument must be an integer");
  end_if;
  if a = 0 then
    [0]
  else
    stdlib::ifactor(a);
    sort([op(%, 2*i) $ i = 1..(nops(%)-1)/2]);
  end_if
end_proc:

