/* 
   ode::simplifySolutions(s)

   DESCRIPTION: 
     This file contains functions to simplify solutions of ordinary differential 
     equations. 
     NOTE: THIS FUNCTION IS UNDER CONSTRUCTION!


   PARAMETER: 
     ++ s   :{DOM_EXPR,DOM_LIST,DOM_SET}
     ++ s    = a set or a list or a sequence of expressions 

   DETAILS: 
     ++ returns simpler solution expressions equivalent to s. 
     ++ Currently only exponential functions
     ++ are combined recursively, integrals are evaluated and the whole
     ++ solution expressions are factorized.
 
   EXAMPLES: 

     >> Ly:=diff(y(x),x$2)-(x^2-x)*diff(y(x),x)+x*y(x);
     
                                                             2
                 x y(x) + diff(y(x), x, x) - diff(y(x), x) (x  - x)
     
     
     >> ode::liouvillianSolutions(Ly,y(x)); 
     
     {      /    /    /        2    3        \ \    \    /  2    3 \
     {      |    |    | x - 2 x  + x  - 2    | |    |    | x    x  |
     { x int| exp| int| -----------------, x | |, x | exp| -- - -- |
     {      \    \    \       x - 1          / /    /    \ 4    6  /
     
        /    /    2 \    /  3 \ \1/2      /    /    /        2    3        \ \
        |    |   x  |    | x  | |         |    |    | x - 2 x  + x  - 2    | |
        | exp| - -- | exp| -- | |    - int| exp| int| -----------------, x | |,
        \    \   2  /    \ 3  / /         \    \    \       x - 1          / /
     
          \    /  2    3 \ /    /    2 \    /  3 \ \1/2
          |    | x    x  | |    |   x  |    | x  | |
        x | exp| -- - -- | | exp| - -- | exp| -- | |   ,
          /    \ 4    6  / \    \   2  /    \ 3  / /
     
             /  2    3 \ /    /    2 \    /  3 \ \1/2
             | x    x  | |    |   x  |    | x  | |
        x exp| -- - -- | | exp| - -- | exp| -- | |    -
             \ 4    6  / \    \   2  /    \ 3  / /
     
           /  2    3 \ /    /    2 \    /  3 \ \1/2 }
           | x    x  | |    |   x  |    | x  | |    }
        exp| -- - -- | | exp| - -- | exp| -- | |    }
           \ 4    6  / \    \   2  /    \ 3  / /    }
     
     
     >> ode::simplifySolutions(%); 
     
                     {                   /    /  3    2 \    \ }
                     {                   |    | x    x  |    | }
                     {                   | exp| -- - -- |    | }
                     {                   |    \ 3    2  /    | }
                     { x - 1, (x - 1) int| --------------, x | }
                     {                   |   2               | }
                     {                   \  x  - 2 x + 1     / }
*/

ode::simplifySolutions:= proc(s,solveOptions={},odeOptions={})
  local intOptions, optIgnoreAnalyticConstraints;
begin 
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;
  intOptions:= null();            
  if has(solveOptions, IgnoreSpecialCases) then 
    intOptions:= intOptions,IgnoreSpecialCases;
  end_if;
  if has(solveOptions, IgnoreAnalyticConstraints) then   
    intOptions:= intOptions,IgnoreAnalyticConstraints;
  end_if;   
  if has(s,int) then 
    return(s); 
  end_if;
  s:= misc::maprec(s,{"_mult"} = proc() 
                                 begin 
                                   combine(_mult(args()),exp,optIgnoreAnalyticConstraints) 
                                 end_proc);
  s:= misc::maprec(s,{"_power"} = proc() 
                                  begin 
                                    _power(combine(op(args(),1),exp,optIgnoreAnalyticConstraints),
                                           op(args(),2)) 
                                  end_proc);
                                         
  // return(map(s,e->Factored::convert_to(factor(simplify(e,optIgnoreAnalyticConstraints)),DOM_EXPR)));
  return(simplify(s,optIgnoreAnalyticConstraints));
end_proc:

