/* 
  ===================================
  METHOD FOR DETECTING HOPELESS CASES
  ===================================

 
    ode::hopelessCases(eq,y,x,solveOptions,odeOptions) finds out if the 
    the expression 'eq' representing an ODE in 'y(x)' contains 
    any of the functions 'Im', 'Re', 'signIm'. 

    If this is the case and inside of any of the arguments of these
    functions there is 'y(x)' or any of its derivatives with respect
    to 'x', then 'TRUE' is returned (meaning the ODE can be considered
    a hopeless case that cannot be solved by any of the methods 
    implemented).

    EXAMPLES: 
      >> ode::hopelessCases((x^2-x^3)*diff(u(x),x,x)+(2*x^2-4*x)*diff(u(x),x)+
                            (6-2*x)*u(x),u,x);
           FALSE  
 
      >> ode::hopelessCases(Im(diff(u(x),x,x))+(2*x^2-4*x)*diff(u(x),x)+
                            (6-2*x)*u(x),u,x);
           TRUE  

*/

ode::hopelessCases:= proc(eq,y,x,solveOptions={},odeOptions={})
  local found, f;
begin 
  found:= FALSE;

  if ode::order(eq,{y},solveOptions,odeOptions) < 2 then 
    return(FALSE)
  end_if;  
  
  f:= proc(elem)
             begin
               if has(op(elem,1),y) then 
                 found:= misc::breakmap();
               end_if;
               elem;
             end_proc;
             
  misc::maprec(eq,
               {"signIm"} = f, 
               {"Im"} = f, 
               {"Re"} = f,
               {"arg"} = f);   
  if found then 
    return(TRUE);
  else 
    return(FALSE);
  end_if;    

end_proc:

