/* 

  Procedure 'ode::insertInits'

  Description. The procedure pluggs initial values 'inits' into a given
               set of solutions 'S' of an ODE and checks whether the 
               solution (or the corresponding derivative) is defined at 
               the initial values. 

  Parameters. 

         S -- set of solutions of an ODE
         x -- indedepent ODE variable 
     inits -- initial values, i.e. '#inits = {initial values}'
   
  The sets 'solveOptions' and 'odeOption' are the standard container for 
  any type of options to be used internally. 

*/

ode::insertInits:= proc(S,x,inits,solveOptions={},odeOptions={})
  local Idents, y, elem, initialConditions;
begin
  Idents:= {};
  misc::maprec(inits,
               {"function"} = proc(elem)
                              begin
                                if type(elem) = "function" then 
                                  Idents:= Idents union {op(elem,0)}
                                end_if;
                                elem;
                              end_proc);  
  Idents:= indets(Idents);  
  if type(S) <> DOM_SET then 
    return(TRUE);
  end_if;
  if nops(Idents) = 1 then 
    y:= Idents[1];
    initialConditions:= rhs(inits);
    S:= misc::maprec(S,{"int"} = proc(elem) 
                                       begin
                                         if has(op(elem,1),x) then 
                                           return(genident()); 
                                         else
                                           return(elem);
                                         end_if;  
                                       end_proc);                         
    for elem in S do 
      if traperror(evalAt(initialConditions,y=fp::unapply(elem,x))) <> 0 then 
        S:= S minus {elem};
      end_if;
    end_for;  
  end_if;      
  if S = {} then 
    return(FALSE);
  end_if;
  
  return(TRUE);
end_proc:

