/* 
  ode::mapsol(s,f) 

     maps the function f on s, where s is a solution of an ODE,
     i.e. either FAIL or a set or a solve result or a union
*/

ode::mapsol:= proc(_s,f)
  local xx;
  save MAXEFFORT;
begin
  /*
     The last two arguments 'args(args(0)-1)' and 'args(args(0))' are assumed 
     to be 'solveOptions', 'odeOptions'. 
  */
  case type(_s)
    of DOM_FAIL do
      return(FAIL);
    of RootOf do
      return(Dom::ImageSet(f(op(_s,2),args(3..args(0)-2)),op(_s,2),_s));
      // This means we have something like e.g. RootOf(X25^4 + X25 + 1, X25)
      // and we return the image set 
      //
      //             {f(X25) | X25 in RootOf(X25^4 + X25 + 1, X25)}
    of DOM_SET do
      if nops(_s) = 0 then
        return({})
      else
        MAXEFFORT:= MAXEFFORT/nops(_s);
        return(map(_s,args(2..args(0)-2)) minus {undefined})
      end_if
    of piecewise do
      return(piecewise::extmap(_s, ode::mapsol, args(2..args(0))))
    of Dom::ImageSet do
      return(map(_s,args(2..args(0)-2)))
    of "_union" do
      MAXEFFORT:= MAXEFFORT/nops(_s);
      _s:= map([op(_s)],ode::mapsol,args(2..args(0)));
      return(_union(op(_s)));
    otherwise
      // return(f(_s,args(3..args(0))))
      xx:= genident();
      // Proceed similar to the case 'of RootOf' above: create an image 
      // set parametrized by 'xx' running through the element of '_s'. 
      return(Dom::ImageSet(f(xx, args(3..args(0)-2)), xx, _s));
      // return({piecewise([xx in _s, f(xx, args(3..args(0)))])})
  end_case;

end_proc:

