/*
 
  ode::mkODE([a_i], y, x)

  DETAILS: 

    ++ returns a linear homogenous differential equation Ly in y(x), 
    ++ where the last element of the list [a_i] corresponds to
    ++ the leading coefficient of Ly.


  EXAMPLE: 
   
    >> ode::mkODE([-1,4*x,4*x^2], y, x);

                                            2
            - y(x) + 4 x diff(y(x), x) + 4 x  diff(y(x), x, x)
*/

ode::mkODE := proc(coef, y, x, solveOptions={}, odeOptions={})
  local i;
begin
  return(_plus( coef[i+1]*diff(y(x), x$i) $ i=0..nops(coef)-1 ));  
end_proc:


