/*
  ode::ode2poly(Ly, y, x, n)
  
  PARAMETER: 
    ++ Ly, y(x)   :DOM_EXPR
    ++ y, x       :DOM_IDENT
    ++ n          :DOM_INT


  DESCRIPTION: 
    ++ converts Ly in a polynomial in the derivations of y(x).


  EXAMPLE: 
    >> ode::ode2poly(-diff(y(x),x,x)/x+y(x)/4/x^3-diff(y(x),x)/x^2,y,x,2);

             / y(x)   diff(y(x), x)   diff(y(x), x, x)
         poly| ---- - ------------- - ----------------,
             |    3         2                x
             \ 4 x         x
         
                                                 \
         [y(x), diff(y(x), x), diff(y(x), x, x)] |
                                                 |
                                                 /
*/

ode::ode2poly:= proc(eq,y,x,n,solveOptions={},odeOptions={})
  local k;
begin
  return(poly(eq,[diff(y(x),x$k) $ k=0..n]));
end_proc:     

