
/*
  ode::simplifyIntegrationConstants(f, y, z, csts, solveOptions,odeOptions)

  DETAILS: 

   Given a function f(z), replace constant subexpressions containing some 
   integration constants by simpler ones. 
*/

ode::simplifyIntegrationConstants:= proc(f, y, z, csts, solveOptions,odeOptions)
  local C, i, paths;
begin
  for C in csts do
    paths:= [prog::find(f, C)];
    if nops(paths) = 1 and nops((paths:= op(paths, 1))) > 0 then
      // C occurs only once, but does not equal f
      // we are looking for the greatest subexpression of f not containing z,
      // but containing C
      i:= 0;
      while has(op(f,[op(paths,1..i)]),z) or has(op(f,[op(paths,1..i)]),y) do
        i:= i+1
      end_while;
      f:= subsop(f,[op(paths,1..i)] = C);
    end_if;
  end_for;

  return(f);  
end_proc:


