/*    ---------------- warning.mu ---------------------

We implement a special function to deal with warnings produced
by ODE. We do not want ODE to give the same warning several 
times. Currently, due to the design of ODE it may happen that e.g.
the warning "solutions may be lost" occurs several times (due to 
then fact that within different algorithms each of them may fail to 
compute a particular (sub-)class of solutions). 

The idea is to have a static variable 'odeWarnings', which stores 
the warnings in a table. Instead of calling 'warning("...")' we
call 'ode::odeWarning("Text")', which then checks whether the 
warning "Text" has already been given. If the warning "Text" has
already been given, then it does not do anything. Otherwise,
it gives the warning "Text" using the standard function 'warning'. 

     CALL: ode::odeWarning(...)

ARGUMENTS: either a string (the text for a warning) or 
           the identifier 'Clear' for resetting the value 
           of the table of warnings. 

  EXAMPLE: See 'ODE/clairaut.mu' for an example of use. 

*/

proc() 
  local warningTable;
  option escape;
begin
  warningTable:= table();
  ode::odeWarning:= proc(x)
  begin 
    if x = Clear then 
      warningTable:= table();
    else 
      if type(x) <> DOM_STRING then 
        error("argument must be a string for the warning or 'Clear'");
      elif not contains(warningTable, x) then 
        warningTable[x]:= TRUE;
        context(hold(warning)(x));
      end_if;
    end_if;
  end_proc;
end_proc():
