/* 

  ============================================
  METHOD FOR 1ST ORDER HOMOGENEOUS LINEAR ODES
  ============================================

  DETAILS: 

  ode::firstord(eq,y,x) recognizes and solves the first-order linear 
  homogeneous differential equation eq=0 in y(x) by direct integration.

  Output: either a solution or FAIL

  EXAMPLE: 

    >> ode::firstord(x^2*diff(y(x),x)+3*x*y(x),y,x);
*/

ode::firstord :=
proc(eq,y,x,solveOptions,odeOptions)
  local f,_a,intOptions, optIgnoreAnalyticConstraints;
begin
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;  
  intOptions:= null();            
  if has(solveOptions, IgnoreSpecialCases) then 
    intOptions:= intOptions,IgnoreSpecialCases;
  end_if;
  if has(solveOptions, IgnoreAnalyticConstraints) then   
    intOptions:= intOptions,IgnoreAnalyticConstraints;
  end_if;   
  // recognizes equations of the form a(x)*diff(y(x),x)+b(x)*y(x)=0
  f:= subs(eq,diff(y(x),x)=`#yp`);
  f:= ode::normal(f,List,Expand=FALSE)[1];
  if not iszero((_a:=coeff(f,`#yp`,1))) then
    f:= ode::normal(-coeff(f,`#yp`,0)/_a/y(x));
    if not has(f,{y,FAIL}) then // try to integrate y'/y = f
      userinfo(1,"first-order linear homogeneous differential equation");
      //return(simplify(expand(exp(int(f,x,intOptions)), optIgnoreAnalyticConstraints), optIgnoreAnalyticConstraints))
      return(simplify(exp(int(f,x,intOptions)), optIgnoreAnalyticConstraints))
    end_if
  end_if;
  
  return(FAIL);
end_proc:
