 //    
 
 /* 
   main function to solve a single differential equation eq=0 in y(z) 
   with initial conditions inits */
 
 
ode::solve_eq :=
 proc(eq,y,z,inits={}:DOM_SET,solveOptions={},odeOptions={})
   /*
    Note from Kai: The defaults for 'solveOptions' and 'odeOptions'
    should not be necessary in the final version. Check the functions
      ./TOOLS/selectSolutions.mu, ./factor.mu,
      ./equidimy.mu, ./solvesys.mu, solve.mu, ./solvably.mu, 
      ./ymissing.mu, ./exact2nd.mu, ./diff.mu, ./exactnth.mu, 
      ./riccati.mu, ./lagrange.mu, ./autonom.mu, ./autonom.mu,
      ./equidimx.mu, ./solvablx.mu, ./interch.mu, ./intfacts2.mu, 
      ./intfacts2.mu
   */
   local _l,i,den,s,optIgnoreAnalyticConstraints,indepOfY,
         sin_pow,cos_pow;
   save MAXEFFORT;
 begin
   
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;
   if ode::depth>ode::maxDepth then
     return({FAIL})
   end_if;
   if type(eq)="_equal" then
     eq:=op(eq,1)-op(eq,2)
   end_if;
   if has(eq,exp) then
     eq:=combine(eq,exp,optIgnoreAnalyticConstraints)
   end_if;// simplify exp(t)*exp(-t)
   // The following 3 lines of deactivated code were in general not a good idea
   // since besides possible simplification they corrupt the structure 
   // of the input ODE and thus make it impossible for some of the look-up
   // methods for realize the correct type of equation. Especially in case 
   // of trigonometric functions the use of combine may have effects that 
   // cannot be undone in the context of the look-up methods. 
   // --------------------------------------------------------------------
   //   if has(eq, sin) and has(eq, cos) then
   //     eq:=combine(eq, sincos,optIgnoreAnalyticConstraints)
   //   end_if;  // to simplify sin(z)^2+cos(z)^2
   // --------------------------------------------------------------------
   // We better replace this by a more precise condition in the if-statement:
   sin_pow:= {};
   cos_pow:= {};
   misc::maprec(eq,
                {"_power"} = proc(elem)
                                  begin
                                    if type(op(elem,1)) = "sin" then 
                                      sin_pow:= sin_pow union {op(elem,1)};
                                    elif type(op(elem,1)) = "cos" then 
                                      cos_pow:= cos_pow union {op(elem,1)};
                                    end_if;
                                    elem;
                                  end_proc);       
   if has(sin_pow,y) and has(sin_pow,z) and has(cos_pow,y) and has(cos_pow,z) then 
     eq:=combine(eq, sincos,optIgnoreAnalyticConstraints)
   end_if; // to simplify sin(z)^2+cos(z)^2     

   if iszero(eq) then
     return({y(z)})
   end_if;
   den:=denom(eq,Expand=TRUE); // must not vanish
   eq:=numer(eq,Expand=TRUE); 
   userinfo(2,"trying to factor");
    _l:=maprat(eq,factor); // to avoid problems with gcd 
   // Anpassung an Umstellung von Factored::_index (Walter 29.12.04)
   _l:= coerce(_l, DOM_LIST);
   userinfo(2,"factorization ".
            (if nops(_l)=3 then "failed" else "worked" end_if));
//   if nops(_l) > 1 then
//     MAXEFFORT:= MAXEFFORT/(nops(_l) div 2)
//   end_if;
   indepOfY:= [];
   for i from 1 to nops(_l) div 2 do 
     if not has(_l[2*i],y) then 
       indepOfY:= append(indepOfY,_l[2*i]);    
     end_if;
   end_for;  
   if nops(indepOfY) = ((nops(_l) div 2)-1) then 
     s:=[ode::solve_eq_irred(eq,y,z,inits,den,
                             solveOptions,odeOptions)];
   else  
     s:=[ode::solve_eq_irred(_l[2*i],y,z,inits,den,
                             solveOptions,odeOptions) $ i=1..nops(_l) div 2];
   end_if;
   if contains(s, FAIL) > 0 then
     {FAIL}
   else
     _union(op(s))
   end_if
end_proc:
 
 
 // returns a set of solutions or FAIL
ode::solve_eq_irred :=
 proc(eq, y, z, inits, den, solveOptions={}, odeOptions={})
   local n, s, _l0, _l, sol, i, 
         csts: DOM_SET, // set of newly generated integration constants
         islin, yp, elim, r, Konst, res, optIgnoreAnalyticConstraints, initConds,
         method, tmp;
 begin
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;
   if inits <> {} then 
     odeOptions:= odeOptions union {#inits = inits}; 
   end_if;       
   if has(odeOptions,#inits) then 
     initConds:= select(odeOptions,has,#inits)[1];
   else 
     initConds:= {};
   end_if;     
   islin:= FALSE;
   method:= table():
   userinfo(2,"solving ODE",eq,"with respect to",y(z));
   if not testtype(eq,Type::ODE(y,z)) then
     error("not an ordinary differential equation in the given variable")
   end_if;
   n:=ode::order(eq,{y},solveOptions,odeOptions);
   if n=-1 then
     return({})
   end_if; // no y(..)
   userinfo(2,"ordinary differential equation of order",n);
   if n=0 then
     yp:= genident("y");
     s:=subs(eq,y(z)=yp);
     sol:= solve(s, yp, op(solveOptions))
   elif has(odeOptions,Type) then  
     // BEGIN OF PROCESSING USER OPTIONS LIKE 'Type = Clairaut' etc. 
     sol:= FAIL;
     if contains(odeOptions, Type = ExactFirstOrder) then 
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:= ode::exact_first_order(eq/den,y,z,solveOptions,odeOptions);             
     elif contains(odeOptions, Type = ExactSecondOrder) then   
       if n <> 2 then 
         error("expecting a second order differential equation");
       end_if;  
       sol:= ode::exact_second_order(eq/den,y,z,solveOptions,odeOptions);             
     elif contains(odeOptions, Type = Homogeneous) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::homogeneous(eq,y,z,solveOptions,odeOptions);             
     elif contains(odeOptions, Type = Riccati) then 
       // First try the look-up methods and afterwards generic methods 
       // if the look-up does not provide a result
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:= ode::lookUp1stOrderRiccati(eq,y,z,solveOptions,odeOptions);
       if sol = FAIL then
         sol:=ode::riccati(eq,y,z,solveOptions,odeOptions);             
       end_if;
     elif contains(odeOptions, Type = Lagrange) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::lagrange(eq,y,z,solveOptions,odeOptions)             
     elif contains(odeOptions, Type = Bernoulli) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::bernoulli(eq,y,z,solveOptions,odeOptions);             
     elif contains(odeOptions, Type = Abel) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::abel(eq,y,z,solveOptions, odeOptions);             
     elif contains(odeOptions, Type = Chini) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::chini(eq,y,z,solveOptions, odeOptions);             
     elif contains(odeOptions, Type = Clairaut) then   
       if n <> 1 then 
         error("expecting a first order differential equation");
       end_if;  
       sol:=ode::clairaut(eq,y,z,solveOptions,odeOptions);             
     elif contains(odeOptions, Type = IntegratingFactor) then   
       sol:=ode::integratingFactor(eq,y,z,solveOptions,odeOptions); 
     end_if;
     // END OF PROCESSING USER OPTIONS LIKE 'Type = Clairaut' etc.
   elif (sol:=ode::separate(eq,y,z,n,solveOptions,odeOptions))=FAIL then
       // first try to recognize linear equations 
     _l0:=[diff(y(z),z$i) $ i=0..n];
     /* I replace in the following line eq by eq0=expand(simplify(eq/den)),
     because if eq0 is linear and the homogeneous part of eq0 has
     rational coefficients and the inhomogeneous part is non-rational, then
     the coefficients of eq are no longer rational and solve_linear fails. */
//     if den <> 1 then _l:=Type::Linear(expand(simplify(eq/den,optIgnoreAnalyticConstraints),optIgnoreAnalyticConstraints),_l0) end_if:
     if den <> 1 then //warning("");
       if has(den,ln) or has(eq,ln) then 
         _l:=Type::Linear(simplify(eq/den,optIgnoreAnalyticConstraints),_l0);
       elif has(den,sin) or has(eq,sin) or has(den,cos) or has(eq,cos) then
         if has(den,z) then 
           _l:=Type::Linear(simplify(eq/den,optIgnoreAnalyticConstraints),_l0);
         else
           _l:=Type::Linear(eq/den,_l0);
         end_if;  
       elif has(den,sinh) or has(eq,sinh) or has(den,cosh) or has(eq,cosh) or has(eq,cot) then
         if has(den,z) then 
           _l:=Type::Linear(simplify(eq/den,optIgnoreAnalyticConstraints),_l0);
           if _l = FALSE then 
             _l:= Type::Linear(expand(simplify(eq/den,optIgnoreAnalyticConstraints),ArithmeticOnly/*,optIgnoreAnalyticConstraints*/),_l0);
           end_if;
         else
           _l:=Type::Linear(eq/den,_l0);
         end_if;  
       else 
         _l:= FALSE;            
         if _l = FALSE and ((tmp:= poly(eq/den,_l0))) <> FAIL and {degree(tmp,_l0[i]) $ i = 1..n+1} subset {0,1} then 
           tmp:= [expand(simplify(expr(coeff(tmp,_l0[i])))) $ i = 1..n+1, expand(simplify(coeff(tmp,[0 $ n+1])))];
           if has(tmp,y) then 
             _l:= FALSE;
           else
             _l:= tmp;
           end_if;  
         end_if;
       end_if:
     end_if;

     if den=1 or _l=FALSE then _l:=Type::Linear(eq,_l0) end_if:
     if _l<>FALSE then
       islin:=TRUE;
       sol:=ode::solve_linear(_l,z,n,solveOptions, odeOptions)
     else // non linear
       userinfo(2,"non linear ordinary differential equation");
       if n=2 then 
         sol:=ode::exact_second_order(eq/den,y,z,solveOptions,odeOptions);
//         if sol=FAIL then 
//           //sol:=ode::integratingFactorsOrder2_1(eq,y,z,solveOptions,odeOptions) 
//           sol:=ode::integratingFactor(eq,y,z,solveOptions,odeOptions);
//         end_if:
       end_if:
       if sol=FAIL and n>=3 then
         sol:=ode::exact_nth_order_nonlinear(eq/den,y,z,solveOptions,odeOptions)
       end_if:
       if sol=FAIL then 
         sol:=ode::autonomousEq(eq,y,z,n,solveOptions,odeOptions);
         if sol <> FAIL then 
           /* 
             We first check if the ODE 'eq' admits constant solutions. 
             If this is not true, we use 'ode::removeConstants' to 
             remove constant elements in 'sol' introduced by 
             'ode::autonomousEq'.
           */
           Konst:= genident();
           if traperror((tmp:= simplify(evalAt(eq, y(z) = Konst),optIgnoreAnalyticConstraints))) = 0 and 
              not iszero(tmp) then 
             sol:= ode::removeConstants(sol,y,z,inits,solveOptions,odeOptions);
           end_if;
         end_if;
       end_if:
        // exact n-th order equations 
       if sol=FAIL then 
         if n=1 then
           if sol=FAIL then 
             sol:= ode::lookUp1stOrderRiccati(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
             if sol=FAIL and den <> 1 then 
               sol:= ode::lookUp1stOrderRiccati(combine(expand(eq/den)),y,z,solveOptions,odeOptions);    
               if sol<>FAIL and initConds <> {} and 
                  ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
                 sol:= FAIL;
               end_if;  
             end_if;  
           end_if;
           if sol=FAIL then 
             sol:=ode::lookUp1stOrderNonLinearVariousODEs(eq,y,z,solveOptions,odeOptions);
             method["lookUp1stOrderNonLinearVariousODEs"]:= TRUE;
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
             if sol=FAIL and den <> 1 then 
               sol:= ode::lookUp1stOrderNonLinearVariousODEs(combine(expand(eq/den)),y,z,solveOptions,odeOptions);    
             if sol<>FAIL and initConds <> {} and 
                  ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
                 sol:= FAIL;
               end_if;  
             end_if;  
           end_if;
           if sol=FAIL then 
             sol:=ode::exact_first_order(eq/den,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::homogeneous(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then 
             sol:=ode::riccati(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::homogeneousD(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::lagrange(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::bernoulli(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::homogeneousG(eq,y,z,solveOptions,odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::abel(eq,y,z,solveOptions, odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;
           if sol=FAIL then
             sol:=ode::chini(eq,y,z,solveOptions, odeOptions);
             if sol<>FAIL and initConds <> {} and 
                ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
               sol:= FAIL;
             end_if;  
           end_if;  
         end_if
       end_if;
       if sol=FAIL and n=1 then 
         sol:=ode::clairaut(eq,y,z,solveOptions,odeOptions);
         if sol<>FAIL and initConds <> {} and 
           ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
           sol:= FAIL;
         end_if;  
       end_if;
       if sol=FAIL and n=1 then 
         sol:=ode::contact(eq,y,z,solveOptions,odeOptions);
         if sol<>FAIL and initConds <> {} and 
           ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
           sol:= FAIL;
         end_if;  
       end_if;
       if sol=FAIL and n=1 then 
         sol:=ode::solvable_for_x(eq,y,z,solveOptions,odeOptions); 
         if sol<>FAIL and initConds <> {} and 
           ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
           sol:= FAIL;
         end_if;  
       end_if;
       if sol=FAIL and n=1 then 
         sol:=ode::solvable_for_y(eq,y,z,solveOptions,odeOptions); 
         if sol<>FAIL and initConds <> {} and 
           ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
           sol:= FAIL;
         end_if;  
       end_if;
       // eventuell lschen und unten einbauen!
       if sol=FAIL and n=1 then
         //sol:=ode::integratingFactorsOrder1_1(eq,y,z,solveOptions,odeOptions);
         sol:=ode::integratingFactor(eq,y,z,solveOptions,odeOptions minus {Type = IntegratingFactor});
         if sol<>FAIL and initConds <> {} and 
            ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
           sol:= FAIL;
         end_if;  
       end_if;
       // METHOD does not produce results as desired. May be re-activated in the future if 
       // necessary. 
       //
       //       if sol=FAIL and n=1 then
       //         sol:=ode::homogeneousC(eq,y,z,solveOptions,odeOptions);
       //         if sol<>FAIL and initConds <> {} and 
       //            ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
       //            sol:= FAIL;
       //         end_if;  
       //       end_if;
     end_if;
     // currently factoring of diff. operator only implemented for linear eqs 
     if sol=FAIL and islin=TRUE then 
       sol:=ode::factor(eq,y,z,n,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
     if sol=FAIL then 
       sol:=ode::ymissing(eq,y,z,n,solveOptions, odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
     if sol=FAIL and n>1 then 
       sol:=ode::integratingFactor(eq,y,z,solveOptions,odeOptions);
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if:
     if sol=FAIL then 
       sol:=ode::differentiation(eq,y,z,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
     if sol=FAIL then 
       sol:=ode::scale_invariant(eq,y,z,n,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
     if sol=FAIL then 
       sol:=ode::equidimensional_in_y(eq,y,z,n,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
     if sol=FAIL then 
       sol:=ode::equidimensional_in_x(eq,y,z,n,FALSE,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
       // methods that call other methods and/or call solve_eq recursively 
     if sol=FAIL then 
       sol:=ode::interchange(eq,y,z,n,solveOptions,odeOptions); 
       if sol<>FAIL and initConds <> {} and 
         ode::insertInits(sol,z,initConds,solveOptions,odeOptions) = FALSE then 
         sol:= FAIL;
       end_if;  
     end_if;
   end_if;
   // Note: We try the 'lookUp1stOrderNonLinearVariousODEs' here, but only in those 
   //       cases where they were not already applied above (i.e. in those cases where 
   //       'method["lookUp1stOrderNonLinearVariousODEs"] <> TRUE') and if we either have 
   //       not yet found a solution or if the solution found so far is not optimal. E.g. 
   //       this is the case when 'hastype(sol,"solve")' gives 'TRUE' meaning that 
   //       we have a solution, but it may be complicated and not explicit (as e.g. 
   //       returned by 'ode::separate'), such that we want to look for an alternative 
   //       via look-up.     
   if n=1 and method["lookUp1stOrderNonLinearVariousODEs"] <> TRUE then 
     res:= FAIL; 
     if sol = FAIL or 
        (initConds <> {} and ode::insertInits(sol,z,initConds,solveOptions,odeOptions) ) = FALSE or 
        hastype(sol,"solve") then 
       res:=ode::lookUp1stOrderNonLinearVariousODEs(eq,y,z,solveOptions,odeOptions);
       if res<>FAIL and initConds <> {} and 
          ode::insertInits(res,z,initConds,solveOptions,odeOptions) = FALSE then 
         res:= FAIL;
       end_if;  
       if res=FAIL and den <> 1 then 
          res:= ode::lookUp1stOrderNonLinearVariousODEs(combine(expand(eq/den)),y,z,solveOptions,odeOptions);    
         if res<>FAIL and initConds <> {} and 
            ode::insertInits(res,z,initConds,solveOptions,odeOptions) = FALSE then 
           res:= FAIL;
         end_if;  
       end_if;  
     end_if;  
     if res<>FAIL then  
       sol:= res;
     end_if;  
   end_if;   
   if sol=FAIL then
     userinfo(2,"solving the ode fails");
     return(FAIL)
   end_if;
          
   /* Some  procedure  (such  as  ode::autonomousEq)  may  introduce
      potential constant solutions that are in fact not solutions of 
      the original equation. 
      The following checks if constants are indeed solutions. As  we 
      solve the numerator  of  the  very  first ODE, we also have to
      check if explicit solutions are not zeros of the denominator. 
   */

   elim:=
   proc(l)
     local check: DOM_PROC;
     
   begin

     // local method check(f) : checks whether f is a solution
     check:=
     proc(f)
       local res;
     begin
       if traperror((res:= testeq(subs(eq, y(z)= f,EvalChanges), 0))) = 0 and 
          res <> FALSE then 
         return(TRUE)
       else 
         return(FALSE)
       end_if;
     end_proc;
     
     case type(l)
     of DOM_SET do
         l:= select(l, proc() 
                         local s; 
                       begin 
                         if traperror((s:= maprat(subs(den,y(z)=args(1),EvalChanges), 
                                 x -> expand(x,optIgnoreAnalyticConstraints),
                                 DescendInto=TRUE,ReplaceHardToEval))) <> 0 then 
                           return(FALSE) 
                         else 
                           return(bool(s <> 0))
                         end_if;  
                       end_proc);
               
         l:= select(l, f -> if not has(f,[y,z]) and check(f) = FALSE then 
                             return(FALSE)
                           else 
                             return(TRUE)
                           end_if);

         /* For piecewise solutions s, check whether
            the conditions may be simplified by replacing them by
            (eq | y(z) = s) = 0
          */
         l:= map(l,
                 proc(s)
                   local branches,
                   change: DOM_BOOL,
                   i: DOM_INT,
                   cond;
                   
                 begin
                   if type(s) <> piecewise then
                     return(s)
                   end_if;
                 change:= FALSE;
                 branches:= [op(s)];

                 for i from 1 to nops(branches) do
                   // if the condition branches[i][1] is more
                   // complicated than "branches[i][2] is a solution",
                   // then replace that condition
                   if type(branches[i][2]) = DOM_SET then 
                     next;
                   end_if;
                   cond:= (subs(eq, y(z)= branches[i][2], EvalChanges) = 0);
                   cond:= simplify::simplifyCondition(cond);
                   if cond = TRUE then
                     return(branches[i][2])
                   end_if;
                   if Simplify::defaultValuation(cond) <
                     Simplify::defaultValuation(branches[i][1]) then
                     branches[i][1]:= cond;
                     change:= TRUE
                   end_if;
                 
                 end_for;
   
                 if change then
                   piecewise(op(branches))
                 else
                   s
                 end_if
                 end_proc
                 );
         /*
           Finally, where a RootOf appears
           in a set, it is deleted and added as a union. This
           should not happen
         */
         
         r:=select(l, testtype, RootOf);
         if nops(r) > 0 then
           warning("RootOf detected")
         end_if;
         return(l minus r union _union(op(r)));
       of "_union" do
         return(map(l, elim))
       of piecewise do
         return(piecewise::extmap(l, elim))
     end_case;
     // default
     l
   end_proc:
   // sol:= elim(sol);  --> better do this after simplifying the constants of 
   //                       integration; see below
   userinfo(2,"solution is",sol);

   csts:=freeIndets(sol) minus (indets(eq) union {y,z});
   sol:= ode::distributePiecewise(sol, {z}, csts, solveOptions,odeOptions);
   // normalize integration constants
   sol:= ode::mapsol(sol, ode::simplifyIntegrationConstants, y, z, csts, 
                     solveOptions, odeOptions);
   sol:= elim(sol);
   if inits={} then
     return(sol)
   end_if;
   
   userinfo(1,"trying to fulfill initial conditions");
   userinfo(2,"which are",inits);

   // Original comment (not by Kai) by whoever: 
   // for simplicity, assume all integration constants to be real?!
   // map(csts, _save);
   // map(csts, assume, Type::Real);
   // ------------------------------
   
   /* 
     Note by Kai: Originally the procedure ended with the single line: 
     --> 'ode::solvinit(sol,inits,[op(csts)],y,z,solveOptions,odeOptions)'
     The problem, which may occur is the following: The ODE under 
     consideration may have singular solutions (such as polynomial 
     solutions in the case of linear ODEs). In such cases ODE may
     return a fundamental set of solutions, in which the elements 
     are not defined at the intial values. In this situation we 
     should try to compute the singular solutions and - if they 
     exist - call 'ode::solvinit' again with the singular solutions. 
     This is better than to return the empty set and not to try 
     find the singular solutions. 
   */ 
   res:= ode::solvinit(sol, inits, [op(csts)], y, z, solveOptions, odeOptions);

   /*
    These lines could be used to convert single piecewise objects with only 1
    branch that are contained in 'res' to objects of type 'Dom::ImageSet'. 
    Currently this is experimental and thus not activated.     

    map(res, elem -> if type(elem) = piecewise and nops(elem) = 1 then 
                       if type(op(elem,[1,1])) = "_in" and 
                          type(op(op(elem,[1,1]),2)) = solvelib::BasicSet then 
                         Dom::ImageSet(op(elem,[1,2]),
                                       C16, 
                                       op(elem,[1,1,1]))
                       else 
                         elem
                       end_if;    
                     else 
                       elem
                     end_if);
   */
   
   if islin = TRUE and res = {} and type(_l) = DOM_LIST then 
     sol:= ode::solve_linear(_l,z,n,
                             solveOptions, 
                             odeOptions union {#searchForPolynomialSolutionsOnly});
     if has(sol,FAIL) then 
       res:= {}
     else 
       csts:=freeIndets(sol) minus (indets(eq) union {y,z});
       if type(sol) = DOM_SET then 
         res:= ode::solvinit(sol, inits, [op(csts)], y, z, solveOptions, odeOptions);
       else 
         res:= ode::solvinit({sol}, inits, [op(csts)], y, z, solveOptions, odeOptions);
       end_if;
     end_if;     
   end_if;
   
   return(res);
end_proc:


/**********************************************************************************************************************************
  h a n d l i n g    o f   i n i t i a l   c o n d i t i o n s
***********************************************************************************************************************************/
 


/**********************
ode::solvinit(sol, inits, csts, z)

sol - a set (of solutions to some ode, but this does not matter)
inits - a DOM_SET of initial conditions
csts - a list of identifiers
z    - identifier

returns the set of all complex numbers y(z) that
- can be obtained from some element of sol by plugging in some values for the
  constants in csts, and
- satisfy each initial condition


**********************/
ode::solvinit:=
proc(sol: Type::Set, inits: DOM_SET, csts: Type::ListOf(DOM_IDENT), y, z,
     solveOptions: DOM_SET, odeOptions: DOM_SET)
  local l, eq, ini, S, s, i: DOM_INT, deg, maxdeg, ind, indz0, derivs, optIgnoreAnalyticConstraints,
  points, z0, res,
  solvini: DOM_PROC,
  substituteBySet: DOM_PROC,
  checksol:DOM_PROC,
  check: DOM_PROC,
  degini: DOM_PROC;
  
begin
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;

  // ============= LOCAL PROCEDURE =============
  // local method degini
  // in D$n(y), determine n 
  degini:=
  proc(Df)
    local f, i;
  begin
    f:= op(Df, 0);
    i:= 0;
    while type(f)="D" do
      f:= op(f, 1);
      i:= i+1
    end;
    assert(f=y);
    i
  end_proc;

  // ============= LOCAL PROCEDURE =============
  // local method solvini
  // returns all solutions y(z) that can be obtained from a particular element of sol
  // by plugging in some values for csts that satisfy all constraints
  
  solvini:=
  proc(s)
    local ini: DOM_SET, S,
    evalAtSpecial: DOM_PROC;

  begin
    // ============= LOCAL PROCEDURE of 'solvini' =============
    // evalAtSpecial(a, subst)
    // a - expression
    // subst - list of substitutions
    // does the same as evalAt(a, subst), but makes C/0 -> piecewise([C=0, 0])
    // this is necessary to make y=C/z satisfy the initial condition y(0)=0
    // for C=0
    // returns an expression representing a number, or undefined
    evalAtSpecial:=
    proc(a, subst: DOM_LIST)
      local c, l, m, i;
    begin
      // for piecewise, carry out the substitution both  in the conditions and the expressions
      if type(a) = piecewise then
        return(piecewise::extmap
               (piecewise::mapConditions(a, evalAtSpecial, subst),
                evalAtSpecial, subst)
               )
      end_if;
      
      // first try evalAt
      if traperror((c:= evalAt(a, subst))) = 0 and
        not has(c, undefined) then
        return(c)
      end_if;

      if has(a,dirac) then 
        a:= simplify::dirac(a); // necessary for fixing g647110
      end_if;

      //  OBSOLETE COMMENT
      /* The 'expand' is needed since otherwise 

            solve(ode({diff(y(z),z,z) = y(z)/z, y(0) = 0, y'(0) = 1},y(z)))

         will give an incorrect result.
      */
      //a:= expand(a); 
      //  END OF OBSOLETE COMMENT
      
      // substitute into each operand, and check whether that makes any operand undefined
      // we must be careful to remove every operand that *might* be undefined, e.g. hold(limit)(..)
      l:= map([op(a)], evalAtSpecial, subst);
      m:= select(l, _unequal, undefined);
      m:= select(m, _not@has, hold(limit)); // proposed by Stefan, but causes loss of solutions

      if nops(l)=nops(m) then
        // no undefined operands, but do they lie in the domain of the operator?
        if traperror((c:= eval(op(a, 0)(op(l))))) = 0 then
          // yes, they do
          c
        else
          // no, they don't
          undefined
        end_if
      else
        // at least one operand could be undefined
        // we proceed by computing the limit of a at the point to be substituted
        for i from 1 to nops(subst) do
          // Normalization is need to make 'limit' compute better results. The 
          // 'normal' here helps to avoid the 'expand' above, which has been 
          // deactivated. 
          a:= limit(ode::normal(a), op(subst, i));
          // we do not accept infinite results, only numbers
          a:= piecewise::extmap(a, x -> if has(x, infinity) then
                                          undefined
                                        else
                                          x
                                        end_if
                                );
        end_for;
        /* 
          It may occur as a problem that 'a' can be or at least
          contain a symbolic call of 'limit'. This may cause 
          problems in the algorithmic steps below since these 
          unevaluated calls of 'limit' go to the solver as parts 
          of equations etc. 
          These problems can be avoided e.g. using by using the 
          lines 

                  if has(a,hold(limit)) then 
                    return(undefined)
                  else 
                    a;
                  end_if; 

          instead of simply returning 'a'. But note that solutions 
          may be lost if all calls of 'limit' are neglected. 
        */
        // NOTE (by Stefan): it is essential that the result really 
        // represents a number and not, e.g., infinity. Therefore 
        // unevaluated limits can cause problems
        return(a)
      end_if;
    end_proc;
      
    // ============= MAIN OF LOCAL PROCEDURE 'solvini' =============

  
    if s = FAIL then
      warning("possibly missing solutions");
      return({})
    end_if;

    // replace indefinite integrals by definite ones
    // (this is our only chance to plug in values)
 
    s:= misc::maprec(s, {"int"} =
                     proc(J: "int")
                       local X;
                     begin
                       if type(op(J, 2)) <> "_equal" then
                         // write int(f(x), x) as
                         // int(f(X), X=0..x)
                         X:= solvelib::getIdent(R_, indets(J));
                         subsop(J, 
                                1 = subs(op(J,1), op(J, 2) = X),
                                // use one of the initial values as 
                                // starting point for integration 
                                2 = (X = op(lhs(inits[1]),1)..op(J, 2))
                                )
                       else
                         J
                       end_if
                     end_proc
                     );    
    
    // plug s into all initial conditions
    ini:= map(inits,
              // local method plugIntoCondition(l)
              // l - initial condition
              // uses solution s from outer procedure
              // returns l | y = s, computed via evalAtSpecial
              proc(l)
                name plugIntoCondition;
                local ind: DOM_LIST,
                subst: DOM_LIST, c, br;
              begin
                // get all derivatives occurring in l
                ind:= [op(ode::odeIndets(l, {y}, solveOptions,odeOptions))];
                // create substitutions diff(y, z$n) -> diff(s, z$n)
                subst:= map
                        (ind,
                         // local procedure that takes an indeterminate diff(y, z$n)(z0)
                         // determines n = degini(indet)
                         // then computes diff(s, z$n)
                         // finally plugs in z -> z_0
                         proc(indet)
                         begin 
                           evalAtSpecial(diff(s, z$degini(indet)),
                                         [z=op(indet, 1)]);
                           end_proc);
                // if some derivative is undefined, then l is undefined at s                       
                if contains(subst, undefined) > 0 then
                  // return(undefined)
                  return(FALSE)
                end_if;
                // carry out the actual substitution
                // ind contains indets like for example y(0), y'(42)
                // subst contains, in the same order, the corresponding values of s: s(0), s'(42), etc.
                // we do evalAtSpecial(l, [y(0) = s(0), y'(42) = s'(42), ...])
                c:= evalAtSpecial(l, zip(ind, subst, _equal));
                // if the initial conditions is undefined (cannot be evaluated)
                // at the solution s, the this means that s is not a solution to 
                // the initial value problem
                // note that evalAtSpecial also returns undefined if it does not know
                // whether the result represents a number or not; in this case, we may
                // lose solutions
                if c = undefined then
                  return(FALSE)
                end_if;
                // c may contain piecewise objects which must be flattened out
                // that is, X = piecewise([cond1, Y], [cond2, Z])
                // becomes
                // X=Y and cond1 or X=Z and cond2
                c:= misc::maprec(c,
                                 {"_equal"} =
                                 (eq -> piecewise::_equal(op(eq))));
                if type(c) = piecewise then
                  _or((br[1] and br[2]) $br in [op(c)])
                else
                  c
                end_if
              end_proc
              );

    // now we have arrived at a set of conditions that must be satisfied in order that
    // s be a solution
              
    if nops(csts) = 0 then
      // if there are no integration constants (e.g., for singular solutions)
      // then we do not have to solve for them:
      // either s satisfies the initial conditions anyway or not 
      return(piecewise([_and(op(ini)), {s}], [Otherwise, {}]))
    end_if;

    // find those values of the integration constants for which the initial
    // conditions are satisfied
    // that is, s is a solution iff the vector csts is in S
    S:= solve(ini, csts, VectorFormat, op(solveOptions));
    userinfo(10, "Solving initial conditions gives ".expr2text(S));

    // plug in the solution vectors for csts: compute 
    // {s(csts) | csts in S}
    S:= substituteBySet(s, csts, S);

    // ignore points where a solution is undefined: we want to return 1/z and not 
    // piecewise([z<>0, 1/z])
    if type(S) = DOM_SET then
      S:= map(S, piecewise::disregardPoints, z) minus {undefined}
    end_if;

    // substituteBySet may fail, in wich case this particular s gives us no solution
    if S = FAIL then
      warning("possibly missing solutions");
      return({})
    end_if;

    S
  end_proc; // solvini

  // ============= END OF LOCAL PROCEDURE 'solvini' =============

  // ============= LOCAL PROCEDURE =============
  /*
    local method substituteBySet
    returns all functions that can be obtained by replacing
    v by some element of S in the expression a

    we cannot use solvelib::substituteBySet for this since we are handling sets 
    of functions (not of numbers). E.g., we do not want {z+C; C \in C_}
    to be equal to C_
    
  */
  substituteBySet:=
  proc(a, v: DOM_LIST, S): Type::Union(Type::Set, DOM_FAIL)
    local i, sets, vars, s, n, cond, const, subsVec;
  begin

    // local method subsVec(x): plugs in x for v
    subsVec:=
    x-> if type(x) = piecewise then
          piecewise::extmap(x, subsVec)
        else
          a | (v[i] = x[i] $i=1..nops(v))
        end_if;
          
    case type(S)
    of "_union" do
        // plug in the elements of all operands
        // if this fails for some operand, then we lose solutions
        sets:= map([op(S)], u -> substituteBySet(a, v, u));
        if contains(sets, FAIL) > 0 then
          warning("possibly missing solutions")
        end_if;
        return(_union(op(select(sets, _unequal, FAIL))))
      of piecewise do
        // plug in each branch
        // if this does not work for some set in some branch, 
        // then we lose that branch 
        sets:= piecewise::extmap(S, x-> substituteBySet(a, v, x));
        if sets = FAIL then return(FAIL) end_if;
        if has(sets, FAIL) then
          sets:= op(sets);
          sets:= select(sets, _not@has, FAIL);          
          sets:= piecewise(eval(sets));
          return(sets)
        else
          return(sets)
        end_if
      of solvelib::VectorImageSet do
        // S = {s(vars); vars in sets}
        // plugging in s(vars) into v, we get 
        // { (a | v=s(vars)) ; vars in sets} as the set of functions we want
        // However, by convention, a set of functions {z -> f(z, vars); vars in sets} 
        // is expressed as f(z, C1, C2, ..) by introducing new integration constants C1, ...
        // and attacing the conditions C1 in sets[1], ... to them. For sets which just equal C_, 
        // that condition immediately gives TRUE
        // Example: the set of solutions { z-> z+u; u in C_} is expressed as z+C1
        //          the set of solutions { z-> z+r; r in R_} is expressed as piecewise([C1 in R_, z+C1])
        s:= op(S, 1);
        sets:= op(S, 3);
        vars:= op(S, 2);
        cond:= TRUE;
        // given S = {s(vars); vars[1] in sets[1], vars[2] in sets[2], ... }, we first do 
        // cond := vars[1] in sets[1] and vars[2] in sets[2] and ...
        // at the same time, we rename every vars[i] by C_something
        // then we let S be the piecewise
        //     {s} if cond
        for i from (n:= nops(vars)) downto 1 do
          // generate a new free variable
          const:= genident("C");
          cond:= cond and const in sets[i];
          s:= subs(s, vars[i] = const);
        end_for;
        S:= {piecewise([cond, s])};
        // Finally, we substitute s into a
        return(substituteBySet(a, v, S))
      of solvelib::cartesianPower do
        if op(S, 1) = C_ then
          // {a(vars) ; vars in C_^n} is just expressed as a
          // we do not rename the variables vars as C1, C2, .., just leave all constants as they are
          return({a})
        else
          // {a(vars) ; vars in U^n} where U subset C_ is just expressed as a
          // attach the condition vars[i] in U for every variable
          return(piecewise([_and(op(map(v, _in, op(S, 1)))), {a}],
                           [Otherwise, {}]
                           ))
        end_if
      of DOM_SET do
          // finite set: plug in the elements one by one
        return(map(S, subsVec)) 
    end_case;
    // hope for the best
    // note that solvelib::substituteBySet has another semantics. It returns the set *of numbers* 
    // {a(v); v in S}. Example: in this sense, {x+C; C in C_} equals C_. 
    solvelib::substituteBySet(a, v, S)
  end_proc;

  // ============= LOCAL PROCEDURE =============
  /*
     checksol(s)
     checks whether a really satisfies the initial conditions

     uses the local variable a from the outer procedure; a must equal
     the set of all initial conditions
  */

  checksol:=
  proc(s)
    local t;
  begin
    if traperror((t:= subs(inits, y=fp::unapply(s, z), EvalChanges))) <> 0 then
      // cannot even evaluate s at inits, e.g. s=1/x, inits= {y(0)=0}
      return({})
    end_if;
    t:= _and(op(t));
    piecewise([t, {s}], [not t, {}])
  end_proc;
  
  // ============= LOCAL PROCEDURE =============
  /*
    select those elements of S that satisfy the initial conditions
  */
  check:=
  proc(S)
  begin
    case type(S)
      of "_union" do
      of "_intersect" do  
        return(map(S, check))
      of DOM_SET do  
        return(_union(op(map(S, checksol))))
      of piecewise do
        return(piecewise::extmap(S, check))
    end_case;
    // hope for the best
    S
  end_proc;

  // ===================================================
  // ============= MAIN OF 'ode::solvinit' =============
  // ===================================================
  case type(sol)
  of DOM_SET do
      // finitely many families of solutions, each parameterized by integration constants: 
      // select those satisfying the initial conditions one by one
      return(_union(op(map(sol, solvini))))
    of "_minus" do
      // select the correct solutions from the first operand (we need not do this for the second)
      S:= ode::solvinit(op(sol, 1), inits, csts, y, z, solveOptions, odeOptions);
      if S = FAIL then 
        return(FAIL) 
      else 
        return(S minus op(sol, 2))
      end_if 
    of "_union" do
      // select the correct solutions belonging to each operand         
      // --- 
      // Fix for g638525: select the elements that are not FAIL and work with
      // the remaining elements. Do not give up if at there are elements that 
      // are not FAIL! 
      S:= select(map([op(sol)], ode::solvinit, inits, csts, y, z, solveOptions, odeOptions),_not@has,FAIL);
      if S = [] then
        return(FAIL)
      end_if;
      return(_union(op(S)))
    of RootOf do  
    of "solve" do
      if csts = [] then 
        return({});
      end_if;  
      // sol is of the form solve(g(y), y) or RootOf(g(y), y), that is, {y; g(y) = 0}
      // in all integrals, look whether they are of the form int(f(y), y) which we cannot handle 
      // that is, op(sol, 2)=y must not be an integration variable
      // it is harmless if integrals have another integration variable like \int f(u, y) du: 
      // we then hope that we can differentiate under the integral sign and plug in initial values like 
      // y(0), y'(0), etc.
      if contains(map(misc::subExpressions(op(sol, 1), "int"), op, 2),
                  op(sol, 2)) then
        userinfo(10, "Cannot solve initial value problem since solution to ode contains unresolved integral");
        return(FAIL)
      end_if;
      // y(z) is given as an implicit solution; but this does not matter:
      // we want to know for which values of the integration constants C1, C2, .. 
      // our solution y satisfying g(y, C1, C2, ...) = 0 also satisfies the initial conditions
      // first, we use y(z) to denote the solution (solve or RootOf may have created another ident)
      eq:= subs(op(sol, 1), op(sol, 2)=y(z));

      // get all diff(y(z), z$n) in the inits, plus the maximal n
      ind:= ode::odeIndets(inits, {y}, solveOptions, odeOptions);
      maxdeg:=
      proc(S)
      begin
        max(map(S, degini))
      end_proc;

      l:= [];
      
      // By differentiating g(y(z)) repeatedly, derivs becomes a set of equations of the form h(z, y(z), y'(z), ...) = 0
      // that must all be satisfied 
      // (Note that this is only a necessary, not a sufficient condition!!)
      // we sort the differential indeterminates in ind D$n(y)(z0) by z0's
      // as we may substitute one z0 for z at a time
      points:= map(ind, op, 1);
      for z0 in points do
        indz0:= select(ind, indet -> op(indet, 1) = z0);
         // form as many derivatives of eq as needed
        deg:= maxdeg(indz0);
        derivs:= [eq, 0$deg];
        for i from 1 to deg do
          derivs[i+1]:= diff(derivs[i], z) // i-th derivative of eq
        end_for;
        derivs:= rewrite(derivs, D);
        if traperror((derivs:= evalAt(derivs, z=z0))) <> 0 then
          // cannot even evaluate at z0
          return({})
        end_if;
        // to the list l of expressions that must be zero in order that y be a solution, 
        // add the conditions that g(y(z)), d/dz (g(y(z))), d^2/(dz)^2 g(y(z)) etc. are zero at z=z0 
        l:= l.derivs
      end_for;

      // the system consisting of l and all initial conditions must be
      // satisfied. Since initial conditions have some D$n(z_0) on the left
      // hand side, we may simply substitute
      // Note: if we ever allow implicit initial conditions, e.g. y(0)^7 + y(0) = 1, it will
      // not be so easy to proceed here
    
      for ini in inits do
        if not contains(ind, lhs(ini)) then
          warning("Illegal initial condition ".expr2text(ini));
          return(FAIL)
        end_if;
        if traperror((l:= subs(l, ini, EvalChanges))) <> 0 then
          // cannot even evaluate initial condition
          return({})
        end_if
      end_for;
    
      // Now all initial conditions have been plugged into the list l of 
      // implicit equations h(z, y(z), y'(z), ...)
      // determine the set of C1, C2, ... such that these are satisfied
      S:= solve(l, csts, VectorFormat, op(solveOptions));
      
      // from the original implicit equation g(y(z), z, C1, C2, ..) = 0, form the set
      // {g(y, z, C1, C2, ...) ; [C1, C2, ... ] in S}
      
      s:= substituteBySet(subs(eq, y(z)=y), csts, S);
      if s = FAIL then
        userinfo(10, "Could not substitute set of type ".expr2text(type(S)));
        warning("Possibly missing solutions");
        return({})
      end_if;
      // now g | z=z0, y=y0 equals zero for every g in s
      // However, this does not imply y(z0)=y0 for all
      // y(z) with g(z, y(z)) = 0 f. all z; e.g. z0=1, y0=0, g=y*(z-y)
      // let S be the union over all {y; g(y) = 0}, g in s
      S:= solvelib::Union(hold(solve)(`#g`, y), `#g`, s);
      // select those y that really satisfy the initial conditions
      S:= misc::maprec(S, {piecewise} =
                       (pw -> piecewise::disregardPoints(pw, y)));
      S:= ode::distributePiecewise(S, {z}, {op(csts)}, solveOptions,odeOptions);
      S:= check(S);
      return(S)
    of Dom::ImageSet do
      if nops((l:= sol::dom::variables(sol))) > 1 then
        // probably too complicated
        break
      end_if;
      if type(op(sol::dom::sets(sol))) = Dom::ImageSet then 
        /* 
           Note by Kai: ImageSet contains ImageSet again. No hope for a 
                        generic way of further computation. Try to find 
                        a solution by picking out a particular element of 
                        the image set. 
        */
        return(ode::solvinit({sol::dom::getElement(sol)}, inits, csts, y, z, 
                             solveOptions, odeOptions))
      else   
        return(
        solvelib::Union(solvini(op(sol, 1)), l[1], sol::dom::sets(sol)[1])
               )
      end_if;         
      //return(
      //solvelib::Union(solvini(op(sol, 1)), l[1], sol::dom::sets(sol)[1])
      //       )
    of piecewise do
      // for each branch, determine the solutions in that branch that satisfy
      // the initial conditions as well as the condition of that branch

      /* Note by Kai: Former version of the return value was a problem 
                      since ode::solvinit may return 'FAIL' and thus 
                      ode::selectSolutions returns 'FAIL' and 'FAIL' is 
                      not accepted by '_union'. 
      */
      // return(_union(ode::selectSolutions
      //               (ode::solvinit
      //                (piecewise::expression(sol, i),inits,
      //                 csts, y, z, solveOptions, odeOptions
      //                 ),
      //                piecewise::condition(sol, i),
      //                y, z, solveOptions, odeOptions
      //                )
      //               $i=1..nops(sol)
      //               )
      //        )      
      res:= {ode::selectSolutions
                    (ode::solvinit
                     (piecewise::expression(sol, i),inits,
                      csts, y, z, solveOptions, odeOptions
                      ),
                     piecewise::condition(sol, i),
                     y, z, solveOptions, odeOptions
                     )
                    $i=1..nops(sol)};
      res:= res minus {FAIL};
      if res = {} then 
        return(FAIL);
      else 
        return(_union(op(res)));
      end_if;
  end_case;
  
  userinfo(10, "Cannot solve initial value problem");
  FAIL
end_proc:

// end of file


