/* solves the equation
  l[1]*y(z)+l[2]*diff(y(z),z)+...+l[n+1]*diff(y(z),z$n)+l[n+2]=0 */

ode::solve_linear :=
  proc(l,z,n,solveOptions,odeOptions)
    local inho,i,k,y,partsol,lc,gensol,eq,eqNotNormalized,dummy,cis,
          Y, yy, _C, m, psol, res, j, lNotNormalized, inhoNotNormalized, lcNotNormalized,
          intOptions, y0, y1, y2, eqsubs, dterm1, dterm2, sol, optIgnoreAnalyticConstraints,
          inits;
          //  save Y, yy;
          // global ode::depth; 
  begin 
    optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                  IgnoreAnalyticConstraints;
                else
                  null();
                end_if;
    intOptions:= null();            
    if has(solveOptions, IgnoreSpecialCases) then 
      intOptions:= intOptions,IgnoreSpecialCases;
    end_if;
    if has(solveOptions, IgnoreAnalyticConstraints) then   
      intOptions:= intOptions,IgnoreAnalyticConstraints;
    end_if;   
    if has(odeOptions,#inits) then 
      inits:= select(odeOptions,has,#inits)[1];
    else 
      inits:= {};
    end_if;  
    // delete Y, yy;
    Y:= genident();
    yy:= genident();
    dummy:=" "; // initial value
    
    if ode::depth > ode::maxDepth+1 then 
      return(FAIL) 
    end_if;
    userinfo(1,"linear ordinary differential equation of order ".n);
    if n=0 then // l[1]*y(z)+l[2]=0 
      if iszero(l[1]) then return({}) else return({-l[2]/l[1]}) end_if
    end_if;
    
    userinfo(2,_plus(l[i+1]*diff(Y(z),z$i)$i=0..n)+l[n+2]=0);
    // try first exact_nth_order which deals with the inhomogeneous coeff. 
    y:=ode::exact_nth_order(l,z,n,solveOptions,odeOptions);
    if y<>FAIL then return(y) end_if;
    inho:=l[n+2]; delete l[n+2]; lc:=l[n+1]; // leading coefficient 
    y:=FAIL; 

    if contains(odeOptions,#searchForPolynomialSolutionsOnly) then 
      eq:=ode::normal(_plus(l[i+1]*diff(Y(z),z$i)$i=0..n));
      if traperror((y:= ode::polynomialSolutions(eq, Y(z), " ", solveOptions, odeOptions))) <> 0 or 
         y = {} then 
        y:= FAIL;
      end_if;
      if y <> FAIL and inits <> {} and 
        ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
        y:= FAIL;              
      end_if;
    else 
      if not has(l,z) then
        //--------------
        // Treat the case with constant coeffcients first (independent of the order).
        //--------------
        userinfo(1,"with constant coefficients");
        y:=ode::constant(l,z,n,solveOptions,odeOptions);
        if y <> FAIL and inits <> {} and 
          ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
          y:= FAIL;              
        end_if;        
      elif n=1 then
        y:=[ode::firstord(l[1]*yy(z)+l[2]*diff(yy(z),z),yy,z,solveOptions,odeOptions)]
        /*
          NOTE by Kai: Maybe it would be a good idea to first use look-up 
                       techniques here before stepping into differential
                       Galois theory. 
   
                       If so, first do the following steps as in the case when the 
                       rational coefficients are treated below: 
   
                        > eq:= normal(_plus(l[i+1]*diff(Y(z),z$i)$i=0..n));
                        > inho:= normal(inho*denom(eq)); lc:=normal(lc*denom(eq));
                        > l:= map(l, normal@_mult, denom(eq));
                        > eq:= numer(eq);
   
                        ==> call WeberEq(eq,yy,z,solveOptions={},odeOptions={})
        */
      elif map({op(l)},testtype,Type::RatExpr(z))={TRUE} then  
        //--------------
        // Treat the case with rational coeffcients.
        //--------------
        userinfo(1,"with rational coefficients");
        eq:=ode::normal(_plus(l[i+1]*diff(Y(z),z$i)$i=0..n));
        eqNotNormalized:= _plus(l[i+1]*diff(Y(z),z$i)$i=0..n);
        inhoNotNormalized:= inho;
        inho:=ode::normal(inho*denom(eq,Expand=FALSE)); 
        lcNotNormalized:= lc;
        lc:=ode::normal(lc*denom(eq,Expand=FALSE));
        lNotNormalized:= l;
        l:=map(l, ode::normal@_mult, denom(eq,Expand=FALSE));
        eq:=numer(eq);
        userinfo(3,"try to solve homogeneous part",eq=0);
        y:=ode::euler(Type::Linear(eq,[diff(Y(z),z$i) $ i=0..n]),z,n,solveOptions,odeOptions);
        if y <> FAIL and inits <> {} and 
          ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
          y:= FAIL;              
        end_if;
        // Note, euler is also included in the next lines
        if y=FAIL then         // too, but yields easier (and slower!!) results
          if n=2 then
            /* 
              Note by Kai: Here we introduce the new look-up methods for 
                           2nd order linear ODEs. The look-ups are also
                           tried below for the case when 
   
                            'map({op(l)},testtype,Type::RatExpr(z)) <> {TRUE}'
   
                           Do not normalize a priori. Let this do the look-up 
                           routines when necessary. 
            */
            userinfo(1,"tyring look-up methods for 2nd order linear ODEs"); 
            y:= ode::lookUp2ndOrderLinear(eqNotNormalized,Y,z,solveOptions,odeOptions);
            if y <> {} and inits <> {} and 
              ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
              y:= {};              
            end_if;
            if y <> {} then 
              inho:= inhoNotNormalized;
              eq:= eqNotNormalized;
              l:= lNotNormalized;
              lc:= lcNotNormalized;
            end_if;
            /* 
              Note by Kai: From here on we proceed as before the introduction
                           of the new look-up methods. From here on we start
                           using the differential Galois theory function.
            */
            if y={} then 
              userinfo(1,"looking for Liouvillian solutions, secondOrderCase");
              y:=ode::secondOrder(eq,Y,z,solveOptions,odeOptions);
              if y <> {} and inits <> {} and 
                ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
                y:= {};              
              end_if;
            end_if;
            if y={} then
              userinfo(1,"looking for non-Liouvillian solutions, secondOrderCase");
              // Note by Kai: Here the old look-up part for linear 2nd order ODEs 
              //              starts. 
              y:=ode::specfunc(eq,Y,z,solveOptions,odeOptions);
              if nops(y) = 1 then
                y0:= genident("y0");
                y1:= genident("y1");
                y2:= genident("y2");
                eqsubs:= subs(eq, [diff(Y(z),z,z) = y2, diff(Y(z),z) = y1, Y(z) = y0]);
                dterm1:= combine(expand(diff(eqsubs,y1), optIgnoreAnalyticConstraints),optIgnoreAnalyticConstraints);
                dterm2:= combine(expand(diff(eqsubs,y2), optIgnoreAnalyticConstraints),optIgnoreAnalyticConstraints);
                sol:= y[1];
                y:= y union {sol*int(exp(-int(dterm1/dterm2,z,intOptions))/sol^2,z,intOptions)};
              end_if;   
              // --------------------------------------------------------------------------
              // Kai: Currently we do not want a post-processing of the solutions obtained
              //      here with respect to the initial values since this will exclude 
              //      solutions which are strictly not defined at the intial values given
              //      but the corresponding limit exists, e.g.: sin(x)/x fr x = 0. 
              // --------------------------------------------------------------------------
              //if y <> {} and inits <> {} and 
              //  ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
              //  y:= {};              
              //end_if;
            end_if;
          elif n=3 then
            y:= {};
            if y = {} then 
              y:= ode::lookUp3rdOrderLinear(eqNotNormalized,Y,z,solveOptions,odeOptions);
              if y <> {} and inits <> {} and 
                ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
                y:= {};              
              end_if;  
            end_if;
            if y = {} then 
              userinfo(1,"looking for Liouvillian solutions, redThirdOrderCase");
              y:=ode::thirdOrder(eq,Y,z,solveOptions,odeOptions);
              if y <> {} and inits <> {} and 
                ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
                y:= {};              
              end_if;
            end_if;  
          else
            // the following lines are currently not general possible, although
            // it would be faster, since the complete solvers is designed to
            // yield generic solutions, while in the case here a list of
            // the solutions is needed for correctly solve the inhomogeneous
            // equation
            if inho=0 then 
              userinfo(1,"looking for rational solutions");
              y:=ode::ratsols(eq,Y,z,n,solveOptions,odeOptions);
              if y <> {} and inits <> {} and 
                ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
                y:= {};              
              end_if;
              if y={} then
                userinfo(1,"looking for exponential solutions");
                y:=ode::expsols(eq,Y,z,n,solveOptions,odeOptions);
                if y <> {} and inits <> {} and 
                  ode::insertInits(y,z,inits,solveOptions,odeOptions) = FALSE then 
                  y:= {};              
                end_if;
              end_if;
              if 0<nops(y) and nops(y)<n then
                userinfo(1,"using reduction method"); 
                res:= ode::reduction(eq,Y(z),op(y,1),solveOptions,odeOptions);
                if res <> FAIL then 
                  // In case that the reduction was succesful, we can return 'res'  
                  // right away, since 'ode::reduction' takes care that the necessary 
                  // constants of integration have been introduced.  
                  // Otherwise we do not have a solution 'y', where the constants of 
                  // integration have already been added. Thus we proceed as in the 
                  // cases above and let the code below modify 'y' in an appropriate
                  // way. 
                  return(res);
                end_if;  
              end_if;
            else // equation is inhomogeneous
              userinfo(1,"looking for Liouvillian solutions, partRedHigherCase");
              y:=ode::liouvillianSolutions(eq,Y(z),solveOptions,odeOptions);
              // 
              // Seems to be a potential bottle neck and I do not see any relevant examples
              // that could go through this. Maybe in the future we should replace the above 
              // line by the the following lines using 'traperror' and 'MaxSteps'. 
              // 
              // if traperror((
              //   y:=ode::liouvillianSolutions(eq,Y(z),solveOptions,odeOptions)),MaxSteps=30) <> 0 then 
              //  y:= {};
              // end_if;     
              if nops(y)=0 then
                return(FAIL);
              end_if;
            end_if;
          end_if;
          // doing some simplifications
          if has(y,int) or has(y, exp) and has(y, ln) then
            // in the methods for liouvillian solutions in most
            // cases integrals are remains unevaluated by the call hold(int)(..) 
            userinfo(4,"try to simplify found solutions");
            if traperror((dummy:=ode::simplifySolutions(y,solveOptions,odeOptions)),
              ode::simplifyTime)=0 then
              y:=dummy;
              if has(y,int) then
                dummy:=hold(Unsimplified);
              else
                dummy:=" ";
              end_if;
            else
              // could not simplify within reasonable time
              dummy:=hold(Unsimplified)
            end_if;
          end_if;
        end_if;
        //--------------
        // End of case with rational coeffcients.
        //--------------
      else
        userinfo(1,"with non constant coefficients");
        if n=2 then 
          userinfo(1,"tyring look-up methods for 2nd order linear ODEs");
          /* Note by Kai: 'l' is not normalized here. Hence, we do not have 
                          to be careful here.
          */ 
          eqNotNormalized:=(_plus(l[i+1]*diff(Y(z),z$i)$i=0..n));
          y:= ode::lookUp2ndOrderLinear(eqNotNormalized,Y,z,solveOptions,odeOptions);
          if y = {} then 
            y:= FAIL;
          end_if;
        end_if;
        if n=3 then 
          userinfo(1,"tyring look-up methods for 3nd order linear ODEs");
          /* Note by Kai: 'l' is not normalized here. Hence, we do not have 
                          to be careful here.
          */ 
          eqNotNormalized:=(_plus(l[i+1]*diff(Y(z),z$i)$i=0..n));
          y:= ode::lookUp3rdOrderLinear(eqNotNormalized,Y,z,solveOptions,odeOptions);
          if y = {} then 
            y:= FAIL;
          end_if;
        end_if;
      end_if;
      
    end_if;
    
    userinfo(2,"solution of homogeneous part is",y); 
    if y=FAIL then return(FAIL) /*return(ode::adjoint(l,z,inho,solveOptions,odeOptions))*/ end_if;
    cis:=[genident("C") $ i=1..n];
    if type(y) = piecewise then 
      gensol:= piecewise::extmap(y, elem -> _plus(op(zip(cis,[op(elem)],_mult))));
    else 
      gensol:=_plus(op(zip(cis,[op(y)],_mult)));
    end_if;
    // a solution of the homogeneous part of the linear DE is C1*y[1]+...+Cn*y[n]
    // we now find a particular solution of the full equation 
    // using the method described on page 314 of Zwillinger   
    // (Variation of parameters)                              
    if inho<>0 and has(y,RootOf) then
      if ode::printWarningsFlag then 
        ode::odeWarning("implicit solutions found, cannot solve inhomogeneous equation. \n".
        "Solutions of the homogeneous part are ".expr2text(y));
      end_if;
      return(FAIL)
    end_if;
    userinfo(4,"searching for a particular solution");
    //  If we have not find the solution of the homogeneous then we return FAIL
    if y={} then
      return(FAIL)
    else 
      //  The method of variation of constant is very time-consuming and we
      //  can look for a particular solution when the second member of the LODE
      //  has a particular form. If it's a polynomial and all the coefficients
      //  of the differential equation are of convenient degree then we will look for
      //  a polynomial particular solution of the same degree:
      // N.B. if y contains only polynomials then it's better to call directly
      //     ode::variationOfConstants.  
      partsol:=FAIL;
      if inho<>0 and testtype(inho,Type::PolyExpr(z)) and
        not contains(map({op(y)},testtype,Type::PolyExpr(z)),TRUE) and
        map({op(l)},testtype,Type::PolyExpr(z))={TRUE} and 
        ((m:=degree(inho,z))) <> FAIL then
        _C:=[genident() $i=1..m+1];
        psol:=_plus(_C[i+1]*z^i $ i=0..m);
        res:=solve({coeff(poly(_plus(l[j+1]*diff(psol,z$j) $ j=0..n)+inho ,[z]))},
        [_C[i+1] $ i=0..m], VectorFormat, op(solveOptions));
        if res<>{} and not has(res, z) then
          partsol:= solvelib::substituteBySet(psol, [_C[i+1] $i=0..m], res);
          if partsol <> FAIL then
            partsol:= piecewise::extmap(partsol, solvelib::getElement)
          end_if;
          if iszero(partsol) or has(partsol, FAIL) then
            partsol:= FAIL
          end_if;
          userinfo(2,"particular solution is",partsol);
        end_if
      end_if;
      if partsol=FAIL then
        partsol:=ode::variationOfConstants(y, z, inho, n, lc, dummy, solveOptions,odeOptions);
      end_if;
      if partsol=FAIL then return(FAIL) end_if;
      if dummy=hold(Unsimplified) then // prevent evaluations
        {collect(gensol+partsol,cis)}
      else  
        if has(partsol,{sin,cos}) then
          k:=combine(partsol,sincos,optIgnoreAnalyticConstraints); 
          if k<>partsol and has(k,hold(int)) then k:=eval(k) end_if;
          partsol:=k
        end_if;
        gensol:=gensol+partsol;
        /*
        if not has(gensol,int) and has(gensol,exp) and has(gensol,I) then // do some simplifications
          // Note by Kai: ...but do it only if no symbolic integrals have been 
          //              returned, since it does not help in this case; it even 
          //              makes everything terribly slow down. 
          gensol:=
          intlib::complexLnConversion(intlib::applyEulerIdentity(gensol,z),z);
        end_if;
        */
        {collect(gensol,cis)};
      end_if;
    end_if;
  end_proc:

/*
Input: sys is a set of solutions for the homogeneous equation
       z is the independent variable
       inho is the inhomogeneous term
       n is the order of the equation
       lc is the leading coefficient of the equation
       notEval (optional) = Unsimplified to let occuring integrals unevaluated 
Output: FAIL or a particular solution of the inhomogeneous equation
*/
ode::variationOfConstants :=
proc(sys, z, inho, n, lc, notEval=" ", solveOptions, odeOptions) 
  local k, y, i, yy, up, intOptions, optIgnoreAnalyticConstraints, cond, branches,
        eq_sys;
  // save yy, up;
begin
  optIgnoreAnalyticConstraints:= if has(solveOptions, IgnoreAnalyticConstraints) then 
                IgnoreAnalyticConstraints;
              else
                null();
              end_if;
  intOptions:= null();            
  if has(solveOptions, IgnoreSpecialCases) then 
    intOptions:= intOptions,IgnoreSpecialCases;
  end_if;
  if has(solveOptions, IgnoreAnalyticConstraints) then   
    intOptions:= intOptions,IgnoreAnalyticConstraints;
  end_if;   
  // delete yy, up;
  yy:= genident();
  up:= genident();
  // method described on page 314 of Zwillinger (Variation of parameters) 
  if inho=0 then
    0
  else 
    if type(sys) = piecewise then 
      return(piecewise::extmap(sys, elem -> ode::variationOfConstants(elem, z, inho, n, lc, 
                                                                      notEval=" ", 
                                                                      solveOptions, 
                                                                      odeOptions)))  
    end_if;  
    if n <> nops(sys) then
      // the "general" solution is incomplete
      return(FAIL)
    end_if;
    y:=[op(sys)];
    sys:={_plus(diff(y[k],z$i)*up[k] $ k=1..n) $ i=0..n-2,
          _plus(diff(y[k],z$(n-1))*up[k] $ k=1..n)+inho/lc},
         {up[k] $ k=1..n};
    // Now 'sys[1] = set of right-hand-side of equations' and 'sys[2] = set of variables'. 
    userinfo(2,"system to solve is",sys);
    // We need a special strategy when the solutions 'y' of the ODE are of 
    // type 'piecewise'. We rely on the fact that whenever any of the 'y[k]'
    // is of type 'piecewise' then - due to automatic conversion - the element in 
    // the set 'sys[1]' are all of type 'piecewise'. If this is really the case
    // is checked by the following 'if'-statement. If this is not true, we assume 
    // that no 'piecewise' objects are involved and proceed as before in the original 
    // implementation.
    if {type(sys[1][i]) $ i = 1..n} = {piecewise} then 
      // collect all conditions from all 'piecewise' branches
      cond:= {piecewise::condition(sys[1][k],i) $ i = 1..nops(sys[1][k]) $ k = 1..n};
      // initialize container for creating a new 'piecewise' below 
      branches:= [0 $ i = 1..nops(cond)];
      for i from 1 to nops(cond) do  
        // For every condition 'cond[i]' find the corresponding branches from any of the 
        // 'piecewise' objects 'sys[1][1],...,sys[1][n]' in 'sys[1]'. Any of these 
        // encode one equation of a system of linear equations that needs to be solved 
        // using 'linsolve'. 
        eq_sys:= map(_union(select({op(sys[1][k])},has,cond[i]) $ k = 1..n), elem -> op(elem,2));
        eq_sys:= linsolve(eq_sys,sys[2]);
        if eq_sys=FAIL then return(FAIL) end_if;
        // When a solution has been found, create an inner list of the form [condition,solution]. 
        // It is important that 'solution' is of the canonical form in which 'linsolve' returns 
        // it's result, since this form can directly be handed over to 'subs' below. 
        branches[i]:= [cond[i],eq_sys];
      end_for;
      for k from 1 to n do
        // For each k = 1,...,n create a piecewise comtaining the integrals 
        // of the form 'int(eval(subs(up[k],branches[i][2])),z,intOptions)' together 
        // with the condition when they apply. 
        if notEval=hold(Unsimplified) then 
          yy[k]:= piecewise([branches[i][1],
                             hold(int)(subs(up[k],branches[i][2],EvalChanges),z,intOptions)] 
                             $ i = 1..nops(branches));
        else                    
          userinfo(2,"integrating",up[k]);
          yy[k]:= piecewise([branches[i][1],
                             int(subs(up[k],branches[i][2],EvalChanges),z,intOptions)] 
                             $ i = 1..nops(branches));
          userinfo(2,"solution is",yy[k]);
        end_if;            
      end_for;
      // Return the same result as in the elementary case below und rely on 
      // the 'piecewise'-methods to do the correct arithmetical operations. 
      return(_plus(yy[k]*y[k] $ k=1..n))
    else   
      sys:=linsolve(sys);
      if sys=FAIL then return(FAIL) end_if;
      userinfo(2,"solution is",sys);
      // to prevent possible errors or to save time

      if notEval=hold(Unsimplified) then
        for k from 1 to n do
          yy[k]:=hold(int)(subs(up[k],sys),z);
        end_for;
      else // try to evaluate the integrals
        for k from 1 to n do
          userinfo(2,"integrating",up[k]);
          yy[k]:=int(subs(up[k],sys,EvalChanges),z,intOptions);
          userinfo(2,"solution is",yy[k]);
        end_for;
      end_if;
      return(_plus(yy[k]*y[k] $ k=1..n));
    end_if;
  end_if;
end_proc:

/* 
   =============================================================================
   Possible new implementation not yet activated -- just a prototype for testing
   ============================================================================= 
*/
/*
ode::constant :=
proc(l: DOM_LIST, z: DOM_IDENT, n: DOM_INT, solveOptions, odeOptions): Type::Set
  local char_eq, i, X, L, createSolutions, partition, res, alpha, beta;
begin 
  X:= genident();
  char_eq:=poly(_plus(l[i+1]*X^i $ i=0..n), [X]);
  userinfo(2,"solving characteristic equation",char_eq);
  // heuristic for second order case 
  if n = 2 then 
    L:= solve(char_eq, X, IgnoreSpecialCases, op(solveOptions));
    if nops(L) = 2 and freeIndets(L) <> {} then 
      // make sure that in the symbolic case the degenerate situation
      // is treated appropriately, i.e. make a case distinction 
      // with respect to the multiplicities of zeroes of the 
      // characteristic equation
      res:= piecewise([L[1] <> L[2],{exp(L[1]*z),exp(L[2]*z)}],
                      [L[1] = L[2],{exp(L[1]*z),exp(L[1]*z)*z}]);
      if has(odeOptions,IgnoreSpecialCases) or has(solveOptions,IgnoreSpecialCases) then
        return(piecewise::disregardPoints(res))
      else
        return(res)
      end_if;
    elif nops(L) = 1 then 
      // degenerate situation in the non-symbolic case
      return({exp(L[1]*z),exp(L[1]*z)*z})
    else 
      // generic case in the non-symbolic case
      alpha:= Re(L[1]);
      beta:= Im(L[1]);
      if iszero(beta) or has(l,I) then  
        return({exp(L[1]*z),exp(L[2]*z)})
      else
        return({exp(alpha*z)*cos(beta*z),exp(alpha*z)*sin(beta*z)})
      end_if;
    end_if;        
  end_if;

  // What follows is an implementation for the generic case for order 
  // n > 2. First the solver is called with option 'Multiple' to compute 
  // the solution of the characteristic polynomial associated to the 
  // input ODE. Afterwards the local procedure 'createSolutions' is 
  // called to do the main work (see below for details). 

  L:= solve(char_eq, X, /*MaxDegree = n,*/ IgnoreSpecialCases, Multiple, op(solveOptions));

  // Subprocedure to compute all partitions of a fine sets used by
  // the local procedure 'createSolutions' below; the notion of 
  // partitions is standard in discrete combinatorics. 
  partition:= proc(M:DOM_SET) 
                local a, A, B, PowA, PM, S;
              begin
                if M = {} then 
                  return({M});
                else 
                  PM:= {};
                  a:= M[1];
                  A:= M minus {a};
                  PowA:= combinat::powerset(A);
                  for B in PowA do 
                    for S in partition(A minus B) do 
                      PM:= PM union {({B union {a}} union S)};
                    end_for;
                  end_for;
                  return(PM)
                end_if;
              end_proc:

  // Create solutions from the ouput of the solver. The solver has been called with 
  // option 'Mulitple'. So the result 'L' in general will be a union of an object of 
  // type 'Dom::Multiset' and an object of type 'RootOf'. 
  //
  //    (1) In case of 'RootOf(p(z),z)' we assume 'z_i <> z_j' for all solutions 'z_i', 
  //    'z_j' of 'p(z) = 0' whenever 'i <> j' implicitly. Then we return the
  //    solution as 'sum(exp(v*z), v in RootOf(p(z),z))'.
  // 
  //    (2) In case of an object of type 'Dom::Multiset' and if the zeros encoded 
  //    by this set do not contain symbolic parameters, the solutions for the input 
  //    ODE are created paying respect to their mulitplicities as zeros of the 
  //    characteristic polynomial. 
  //   
  //    (3) If additionally to the above situation the zeros of the characteristic
  //    polynomial contain symbolic parameters then a case differentiation is 
  //    made taking into account that some zeros may be equal (and hence lead 
  //    to the degenerate situation). 

  createSolutions:= proc(L) 
                      local res, PM, Part, M, equalZeros, branches, elem, i, j, v, 
                            conditions, equals, zeros, elem2, uneqs, unequals, MM,
                            n, tmp;
                    begin
                      if type(L) = Dom::Multiset then
                        res:= {};
                        if freeIndets(L) = {} or 
                           (args(0) = 2 and args(2) = IgnoreSpecialCases) then 
                           // Option 'IgnoreSpecialCases' has been set or there are 
                           // no symbolic parameters in the set L. In this case we 
                           // just need to respect the multiples to construct the 
                           // degenerate solutions appropriately. 
                          L:= [op(L)];
                          zeros:= select({op(map(L, elem -> elem[1]))},has,I);
                          tmp:= [];
                          for i from 1 to nops(L) do 
                            if contains(zeros,L[i][1]) and contains(zeros,conjugate(L[i][1])) then   
                              tmp:= tmp.[(L[i]).[Real]];
                            else
                              tmp:= tmp.[L[i]];
                            end_if;
                          end_for;
                          for elem in tmp do
                            if nops(elem) = 3 then 
                              res:= res union {exp(Re(elem[1])*z)*cos(Im(elem[1])*z)*z^i $ i = 0..elem[2]-1,
                                               exp(Re(elem[1])*z)*sin(Im(elem[1])*z)*z^i $ i = 0..elem[2]-1};
                            else
                              res:= res union {exp(elem[1]*z)*z^i $ i = 0..elem[2]-1};
                            end_if;
                          end_for;  
                          return(res);  
                        else
                          // Here symbolic parameters are involved. We call 'createSolutions'
                          // recursively with a list of lists in this case. The necessary 
                          // case differentiations are then done below.  
                          return(createSolutions([op(L)],partition({i $ i = 1..nops(L)})));
                        end_if;
                      elif type(L) = RootOf then
                        // In case of 'RootOf' solution proceed as described under (2)
                        // in the introducing comment to this procedure.
                        v:= solvelib::getIdent(Any, indets([L,l,z]));
                        return({hold(sum)(exp(v*z), v in L)});
                      elif type(L) = "_union" then 
                        // call 'createSolutions' recursively for each operand of the 
                        // '_union' (which will be either a 'Dom::Multiset' or a 
                        // 'RootOf'. 
                        return(_union(map(op(L),elem -> createSolutions(elem))));
                      elif type(L) = DOM_LIST then
                        // Here we are in the symbolic situation. If '{z_1,...,z_n}' are the 
                        // symbolic roots of the characteristic polynomial of the input ODE 
                        // then we need to consider all partitions of the set and for any 
                        // such partition we have to investigate the case that all roots 
                        // contained in the same subset of the partition coincide. This leads
                        // to the following major efforts in analyzing all possible cases. 
                        PM:= partition({i $ i = 1..nops(L)});
                        branches:= {};
                        conditions:= TRUE;
                        zeros:= {L[i][1] $ i = 1..nops(L)};
                        n:= _plus(L[i][2] $ i = 1..nops(L));
                        uneqs:= {};
                        // Construct the necessary unequalities for the conditions in the 
                        // piecewise-branches to be created later: for each pair of 
                        // distinct symbolic solutions 'z1,z2' of the characteristic equation
                        // the cases whether 'z1 = z2' or 'z1 <> z2' need to be treated. All 
                        // possible unequalities are created here and collected in the set 
                        // 'uneqs'. 
                        for elem in zeros do 
                          zeros:= zeros minus {elem};
                          for elem2 in zeros do 
                            uneqs:= uneqs union {elem <> elem2}
                          end_for;
                        end_for; 
                        // The partitions now serve to treat all cases that can appear. E.g. in the 
                        // case 'n=3' the partition '{{1,2},3}' of the set '{1,2,3}' corresponds to 
                        // the case that 'z1 = z2' and 'z1 <> z3' whereas the set '{{1},{2},{3}}' 
                        // corresponds to the case 'z1 <> z2,  z1 <> z3, z2 <> z3'. Whenever the indices 
                        // of two solutions of the characteristic equation are contained in the same 
                        // subset they are considered to be equal. If they lie in different subsets they
                        // are considered to be distinct. 
                        for Part in PM do 
                          equalZeros:= {};
                          equals:= {};
                          unequals:= {};
                          for M in Part do 
                            equalZeros:= equalZeros union {[[L[i][1] $ i in M],_plus(L[i][2] $ i in M)]};
                          end_for;
                          for M in Part do 
                            Part:= Part minus {M};
                            for MM in Part do 
                              unequals:= unequals union {L[M[1]][1] <> L[MM[1]][1]};
                            end_for;  
                          end_for;  
                          unequals:= _and(op(unequals));                                                 
                          equals:= _and(((equalZeros[j][1][1] = equalZeros[j][1][i]) $ i = 2..nops(equalZeros[j][1])) 
                                              $ j = 1..nops(equalZeros));
                          branches:= branches union {
                                      ([unequals and equals,
                                       {(exp(equalZeros[j][1][1]*z)*z^i $ i = 0..equalZeros[j][2]-1) 
                                            $ j = 1..nops(equalZeros)}])};
                        end_for; 
                        // If 'branches = {[TRUE,{solutions}]}' we do not want to create a piecewise. 
                        // Instead we return '{solutions}' in this case. 
                        if nops(branches) = 1 and branches[1][1] = TRUE then 
                          return(branches[1][2]);
                        end_if;
                        // Finally, we eliminate all branches containing sets having less than 'n' elements,
                        // since they correspond to situations where the characteristic polynomial would have 
                        // degree less than the order of the input ODE. We assume that the parameters do not 
                        // take values that decrease the order of the underlying ODE. 
                        res:= map({op(piecewise(op(branches)))}, elem -> if nops(elem[2])=n then elem else null() end_if);                              
                        if has(odeOptions,IgnoreSpecialCases) then 
                          return(piecewise::disregardPoints(piecewise(op(res))))
                        else 
                          return(piecewise(op(res)));
                        end_if;
                      end_if;
                    end_proc:  
 
  if has(solveOptions,IgnoreSpecialCases) or has(odeOptions, IgnoreSpecialCases) then 
    res:= createSolutions(L,IgnoreSpecialCases);
  else 
    res:= createSolutions(L);
  end_if;


end_proc:
*/

ode::constant :=
proc(l: DOM_LIST, z: DOM_IDENT, n: DOM_INT, solveOptions, odeOptions): Type::Set
  local char_eq,i, X;
begin
  X:= genident();
  char_eq:=poly(_plus(l[i+1]*X^i $ i=0..n), [X]);
  userinfo(2,"solving characteristic equation",char_eq);
  // problem: if char_eq contains parameters, then it may be squarefree
  // for some values of the parameters but not for others. We do not handle
  // this problem yet.
  l:= coerce(polylib::sqrfree(char_eq), DOM_LIST);
  _union(ode::vspace(l[2*i], l[2*i+1], z, solveOptions,odeOptions) $i=1..nops(l) div 2)
end_proc:
