//      

/*++
hermite(n, x) - generates the nth Hermite polynomial

H(0,x) = 1
H(1,x) = 2*x
H(n,x) = 2*x*H(n-1,x) - 2*(n-1)*H(n-2,x) for n > 1
--*/
orthpoly::hermite := proc(n,x)
local i, r0, r1;
begin
  if args(0) <> 2 then error("wrong number of arguments"); end_if;
  if not (domtype(n) = DOM_INT) then 
     return(procname(args()));
  end_if;
  if n < 0 then error("1st argument must not be negative"); end_if;
  if not testtype(x, Type::Arithmetical) then
     error("illegal 2nd argument");
  end_if;
  if domtype(x) = DOM_IDENT or type(x)="_index"
  then case n
       of 0 do return(poly(1, [x]));
       of 1 do return(poly(2*x, [x]));
       otherwise r0 := poly(1, [x]);
                 r1 := poly(2*x, [x]);
                 for i from 2 to n do
                    [r1, r0] := [mapcoeffs(poly(x,[x])*r1 
                                      - poly(i-1,[x])*r0,_mult,2),
                                 r1];
                 end_for;
                 return(r1);
       end_case;
  else case n
       of 0 do return(1);
       of 1 do return(2*x);
       otherwise r0 := 1; 
                 r1 := expand(2*x);
                 if has({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX},
                        domtype(x)) then
                    for i from 2 to n do
                       [r1, r0] := [2*(x*r1 - (i-1)*r0), r1];
                    end_for;
                    return(r1);
                 else
                    for i from 2 to n do
                       [r1, r0] := [2*(x*r1 - (i-1)*r0), r1];
                       r1:= expand(r1);
                    end_for;
                    return(r1);
                 end_if:
      end_case;
  end_if;
end_proc:
