//      

/*++
legendre(n, x) - generates the nth Legendre polynomial

L(0,x) = 1
L(1,x) = x
L(n,x) = 1/n * (   (2*n-1)*L(n-1,x) - (n-1)*L(n-2,x)  );
L(n,x) = 1/(2^n * n!) * diff((x^2-1)^n, x$n), n > 0
++*/

orthpoly::legendre := proc(n, x)
local i, r0, r1;
begin
  if args(0) <> 2 then error("wrong number of arguments"); end_if;
  if not (domtype(n) = DOM_INT) then
     return(procname(args()));
  end_if;
  if n < 0 then error("1st argument must not be negative"); end_if;
  if not testtype(x, Type::Arithmetical) then
     error("illegal 2nd argument");
  end_if;
  if domtype(x) = DOM_IDENT or type(x)="_index"
  then case n
       of 0 do return(poly(1, [x]));
       of 1 do return(poly(x, [x]));
       otherwise r0 := poly(1, [x]);
                 r1 := poly(x, [x]);
                 for i from 1 to n-1 do
                    [r1, r0] :=  [poly((2*i+1)/(i+1)*x,[x])*r1
                                        - poly(i/(i+1),[x])*r0,
                                  r1];
                 end_for;
                 return(r1);
       end_case;
  else case n
       of 0 do return(1);
       of 1 do return(x);
       otherwise r0 := 1; 
                 r1 := expand(x);
                 if has({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX, DOM_INTERVAL},
                        domtype(x)) then
                    for i from 1 to n-1 do
                       [r1, r0] :=  [ ((2*i+1)*x*r1 - i*r0)/(i+1), r1];
                    end_for;
                    return(r1);
                 else
                    for i from 1 to n-1 do
                       [r1, r0] :=  [ ((2*i+1)*x*r1 - i*r0)/(i+1), r1];
                       r1:= expand(r1):
                    end_for;
                    return(r1);
                 end_if:
      end_case;
  end_if;
end_proc:
